/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.bolloom;

import com.teamabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.teamabnormals.endergetic.common.entity.bolloom.AbstractBolloom;
import com.teamabnormals.endergetic.common.entity.bolloom.BalloonColor;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomKnot;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import com.teamabnormals.endergetic.core.interfaces.CustomBalloonPositioner;
import com.teamabnormals.endergetic.core.other.EEDataSerializers;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class BolloomBalloon
extends AbstractBolloom {
    private static final EntityDataAccessor<Optional<UUID>> KNOT_UNIQUE_ID = SynchedEntityData.m_135353_(BolloomBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<BlockPos> FENCE_POS = SynchedEntityData.m_135353_(BolloomBalloon.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<BalloonColor> COLOR = SynchedEntityData.m_135353_(BolloomBalloon.class, EEDataSerializers.BALLOON_COLOR);
    public boolean hasModifiedBoatOrder;
    @Nullable
    private Entity attachedEntity;
    @Nullable
    private UUID attachedEntityUUID;

    public BolloomBalloon(EntityType<? extends BolloomBalloon> entityType, Level world) {
        super(entityType, world);
    }

    public BolloomBalloon(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends BolloomBalloon>)((EntityType)EEEntityTypes.BOLLOOM_BALLOON.get()), world);
    }

    public BolloomBalloon(Level world, UUID ownerKnot, BlockPos pos, float offset) {
        this((EntityType<? extends BolloomBalloon>)((EntityType)EEEntityTypes.BOLLOOM_BALLOON.get()), world);
        float posX = (float)pos.m_123341_() + 0.5f + (this.f_19796_.m_188499_() ? -offset : offset);
        float posY = pos.m_123342_() + 3;
        float posZ = (float)pos.m_123343_() + 0.5f + (this.f_19796_.m_188499_() ? -offset : offset);
        this.m_6034_(posX, posY, posZ);
        this.setOrigin(posX, posY, posZ);
        this.f_19854_ = posX;
        this.f_19855_ = posY;
        this.f_19856_ = posZ;
        this.setFencePos(pos);
        this.setKnotId(ownerKnot);
    }

    public BolloomBalloon(Level world, BlockPos pos) {
        this((EntityType<? extends BolloomBalloon>)((EntityType)EEEntityTypes.BOLLOOM_BALLOON.get()), world);
        float posX = (float)pos.m_123341_() + 0.5f;
        float posY = pos.m_123342_();
        float posZ = (float)pos.m_123343_() + 0.5f;
        this.m_6034_(posX, posY, posZ);
        this.setOrigin(posX, posY, posZ);
        this.f_19854_ = posX;
        this.f_19855_ = posY;
        this.f_19856_ = posZ;
        this.setUntied(true);
        this.setDesiredVineYRot((float)(this.f_19796_.m_188500_() * 2.0 * Math.PI));
        this.setVineYRot((float)(this.f_19796_.m_188500_() * 2.0 * Math.PI), true);
    }

    @Override
    public void m_8119_() {
        if (this.isAttachedToEntity() && (!this.attachedEntity.m_6084_() || this.attachedEntity.m_5833_())) {
            this.detachFromEntity();
        } else if (!this.m_9236_().f_46443_ && this.attachedEntityUUID != null) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.attachedEntityUUID);
            if (entity != null) {
                this.attachToEntity(entity);
            } else {
                EndergeticExpansion.LOGGER.warn("Could not find entity the balloon was attached to with UUID: {}", (Object)this.attachedEntityUUID);
            }
            this.attachedEntityUUID = null;
        }
        super.m_8119_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KNOT_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(FENCE_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(COLOR, (Object)BalloonColor.DEFAULT);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getKnotId() != null) {
            compound.m_128362_("KnotUUID", this.getKnotId());
        }
        compound.m_128356_("FENCE_POS", this.getFencePos().m_121878_());
        compound.m_128344_("Color", (byte)this.getColor().ordinal());
        if (this.isAttachedToEntity() && !(this.attachedEntity instanceof Player)) {
            compound.m_128365_("Pos", (Tag)this.m_20063_(new double[]{this.attachedEntity.m_20185_(), this.attachedEntity.m_20186_(), this.attachedEntity.m_20189_()}));
            compound.m_128362_("AttachedUUID", this.attachedEntity.m_20148_());
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setKnotId(compound.m_128441_("KnotUUID") ? compound.m_128342_("KnotUUID") : null);
        this.setFencePos(BlockPos.m_122022_((long)compound.m_128454_("FENCE_POS")));
        this.setColor(BalloonColor.byOrdinal(compound.m_128445_("Color")));
        if (compound.m_128403_("AttachedUUID")) {
            this.attachedEntityUUID = compound.m_128342_("AttachedUUID");
        }
    }

    public void setKnotId(@Nullable UUID knotUUID) {
        this.f_19804_.m_135381_(KNOT_UNIQUE_ID, Optional.ofNullable(knotUUID));
    }

    @Nullable
    public UUID getKnotId() {
        return ((Optional)this.f_19804_.m_135370_(KNOT_UNIQUE_ID)).orElse(null);
    }

    @Nullable
    public Entity getKnot() {
        return ((ServerLevel)this.m_9236_()).m_8791_(this.getKnotId());
    }

    private void setFencePos(BlockPos fencePos) {
        this.f_19804_.m_135381_(FENCE_POS, (Object)fencePos);
    }

    private BlockPos getFencePos() {
        return (BlockPos)this.f_19804_.m_135370_(FENCE_POS);
    }

    public BalloonColor getColor() {
        return (BalloonColor)((Object)this.f_19804_.m_135370_(COLOR));
    }

    public void setColor(BalloonColor color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public void attachToEntity(Entity entity) {
        this.attachedEntity = entity;
        if (entity instanceof CustomBalloonPositioner) {
            ((CustomBalloonPositioner)entity).onBalloonAttached(this);
        }
        ((BalloonHolder)entity).attachBalloon(this);
    }

    public void detachFromEntity() {
        if (this.attachedEntity != null) {
            ((BalloonHolder)this.attachedEntity).detachBalloon(this);
            Entity entity = this.attachedEntity;
            if (entity instanceof CustomBalloonPositioner) {
                CustomBalloonPositioner customBalloonPositioner = (CustomBalloonPositioner)entity;
                customBalloonPositioner.onBalloonDetached(this);
            }
            this.attachedEntity = null;
        }
    }

    @Nullable
    public Entity getAttachedEntity() {
        return this.attachedEntity;
    }

    public boolean isAttachedToEntity() {
        return this.attachedEntity != null;
    }

    public void updateAttachedPosition() {
        this.m_20256_(Vec3.f_82478_);
        if (this.canUpdate()) {
            this.m_8119_();
            this.incrementTicksExisted(!this.m_9236_().f_46443_);
            Entity entity = this.attachedEntity;
            if (entity instanceof CustomBalloonPositioner) {
                CustomBalloonPositioner customBalloonPositioner = (CustomBalloonPositioner)entity;
                customBalloonPositioner.updateAttachedPosition(this);
            } else if (this.attachedEntity != null) {
                this.m_6034_(this.attachedEntity.m_20185_() + (double)(this.getSway() * Mth.m_14031_((float)(-this.getVineYRot()))), this.attachedEntity.m_20186_() + this.m_6048_() + (double)this.attachedEntity.m_20192_(), this.attachedEntity.m_20189_() + (double)(this.getSway() * Mth.m_14089_((float)(-this.getVineYRot()))));
            }
        }
    }

    @Override
    public void updatePositionAndMotion(double angleX, double angleZ) {
        if (this.m_9236_().isAreaLoaded(this.m_20183_(), 1)) {
            if (!this.isUntied()) {
                float sway = this.getSway();
                this.m_6034_((double)this.getOriginX() + (double)sway * angleX, this.getOriginY(), (double)this.getOriginZ() + (double)sway * angleZ);
            } else if (!this.isAttachedToEntity()) {
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20334_(angleX * (double)0.05f, 0.07f, angleZ * (double)0.05f);
            }
        }
    }

    @Override
    public void updateUntied() {
        BolloomKnot bolloomKnot;
        Entity entity;
        if (this.m_9236_().isAreaLoaded(this.getFencePos(), 1) && !this.isUntied() && !this.m_9236_().m_8055_(this.getFencePos()).m_204336_(BlockTags.f_13039_)) {
            entity = this.getKnot();
            if (entity instanceof BolloomKnot) {
                bolloomKnot = (BolloomKnot)entity;
                bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
            }
            this.setUntied(true);
        }
        if (this.isAttachmentBlocked()) {
            if (!this.isUntied() && (entity = this.getKnot()) instanceof BolloomKnot) {
                bolloomKnot = (BolloomKnot)entity;
                bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
            }
            this.setUntied(true);
        }
    }

    @Override
    public boolean shouldIncrementTicksExisted() {
        return !this.isAttachedToEntity();
    }

    @Override
    public void onBroken(boolean dropFruit) {
        super.onBroken(dropFruit);
        Entity knot = this.getKnot();
        if (knot instanceof BolloomKnot) {
            BolloomKnot bolloomKnot = (BolloomKnot)knot;
            bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
        }
        if (dropFruit) {
            Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)this.getColor().balloonItem.get()));
        }
    }

    public boolean isAttachmentBlocked() {
        BlockPos.MutableBlockPos mutable = this.getFencePos().m_6630_(3).m_122032_();
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = mutable.m_6625_(i);
            if (!this.m_9236_().isAreaLoaded(pos, 1) || this.m_9236_().m_8055_(pos).m_247087_() && this.m_9236_().m_8055_(pos).m_60734_() != Blocks.f_49991_) continue;
            return true;
        }
        return false;
    }

    public void m_6074_() {
        Entity knot;
        if (!this.m_9236_().f_46443_ && (knot = this.getKnot()) instanceof BolloomKnot) {
            BolloomKnot bolloomKnot = (BolloomKnot)knot;
            bolloomKnot.setBalloonsTied(bolloomKnot.getBalloonsTied() - 1);
        }
        super.m_6074_();
    }

    @Override
    public Block getBlockForParticle() {
        return this.getColor() == BalloonColor.DEFAULT ? super.getBlockForParticle() : (Block)Sheep.f_29800_.get(this.getColor().color);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof DyeItem && this.getColor().color != ((DyeItem)itemstack.m_41720_()).m_41089_()) {
            if (!this.m_9236_().f_46443_) {
                this.setColor(BalloonColor.byDyeColor(((DyeItem)itemstack.m_41720_()).m_41089_()));
                EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_7111_(player, vec, hand);
    }

    public double m_6048_() {
        return 1.75;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.getColor().balloonItem.get());
    }

    public boolean m_6783_(double distance) {
        if (this.isAttachedToEntity()) {
            return this.attachedEntity.m_6783_(distance);
        }
        return super.m_6783_(distance);
    }
}

