/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block.poise;

import com.teamabnormals.endergetic.common.block.entity.BolloomBudTileEntity;
import com.teamabnormals.endergetic.core.other.tags.EEBlockTags;
import com.teamabnormals.endergetic.core.registry.EEBlockEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BolloomBudBlock
extends BaseEntityBlock {
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");
    private static final VoxelShape INSIDE = BolloomBudBlock.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)15.0, (double)12.5);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)BolloomBudBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (VoxelShape)Shapes.m_83124_((VoxelShape)INSIDE, (VoxelShape[])new VoxelShape[0]), (BooleanOp)BooleanOp.f_82685_);
    protected static final VoxelShape SHAPE_OPENED = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);

    public BolloomBudBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Block.m_49796_((double)-16.0, (double)-16.0, (double)-16.0, (double)32.0, (double)32.0, (double)32.0);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
    }

    protected boolean isValidGround(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.m_60713_(Blocks.f_50259_) || state.m_204336_(EEBlockTags.END_PLANTABLE) || state.m_204336_(EEBlockTags.POISE_PLANTABLE);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.m_60710_((LevelReader)world, currentPos)) {
            boolean opened = (Boolean)stateIn.m_61143_((Property)OPENED);
            return this.placePedals(world, currentPos, opened) && opened ? (BlockState)stateIn.m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(true)) : this.resetBud(world, currentPos);
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.isValidGround(worldIn.m_8055_(blockpos), (BlockGetter)worldIn, blockpos) && !BolloomBudBlock.isAcrossOrAdjacentToBud(worldIn, pos);
    }

    public boolean placePedals(LevelAccessor world, BlockPos pos, boolean opened) {
        if (!((Boolean)world.m_8055_(pos).m_61143_((Property)OPENED)).booleanValue() && this.canPutDownPedals(world, pos)) {
            if (opened) {
                for (BolloomBudTileEntity.BudSide side : BolloomBudTileEntity.BudSide.values()) {
                    BlockPos sidePos = side.offsetPosition(pos);
                    if (!world.m_8055_(sidePos).m_60812_((BlockGetter)world, pos).m_83281_()) continue;
                    world.m_46961_(sidePos, true);
                }
            }
            return true;
        }
        if (opened) {
            return false;
        }
        return false;
    }

    public static boolean isAcrossOrAdjacentToBud(LevelReader world, BlockPos pos) {
        Block block = (Block)EEBlocks.BOLLOOM_BUD.get();
        for (Direction directions : Direction.values()) {
            if (world.m_8055_(pos.m_5484_(directions, 2)).m_60734_() != block) continue;
            return true;
        }
        BlockPos north = pos.m_121945_(Direction.NORTH);
        BlockPos south = pos.m_121945_(Direction.SOUTH);
        return world.m_8055_(north.m_122029_()).m_60734_() == block || world.m_8055_(south.m_122029_()).m_60734_() == block || world.m_8055_(north.m_122024_()).m_60734_() == block || world.m_8055_(south.m_122024_()).m_60734_() == block;
    }

    private boolean canPutDownPedals(LevelAccessor world, BlockPos pos) {
        for (BolloomBudTileEntity.BudSide sides : BolloomBudTileEntity.BudSide.values()) {
            BlockPos sidePos = sides.offsetPosition(pos);
            if (world.m_6425_(sidePos).m_76178_() && world.m_8055_(sidePos).m_60812_((BlockGetter)world, sidePos).m_83281_()) continue;
            return false;
        }
        return true;
    }

    private BlockState resetBud(LevelAccessor world, BlockPos pos) {
        if (world.m_7702_(pos) instanceof BolloomBudTileEntity) {
            ((BolloomBudTileEntity)world.m_7702_(pos)).resetGrowing();
        }
        return this.m_49966_();
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return (Boolean)p_220053_1_.m_61143_((Property)OPENED) != false ? SHAPE_OPENED : SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{OPENED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BolloomBudTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BolloomBudBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EEBlockEntityTypes.BOLLOOM_BUD.get()), BolloomBudTileEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

