/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.teamabnormals.endergetic.client.particle.data.CorrockCrownParticleData;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.core.other.EEEvents;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CorrockCrownWallBlock
extends CorrockCrownBlock {
    private static final Map<ResourceLocation, Supplier<CorrockCrownWallBlock>> CONVERSIONS = (Map)Util.m_137469_((Object)Maps.newHashMap(), conversions -> {
        conversions.put(BuiltinDimensionTypes.f_223538_.m_135782_(), EEBlocks.OVERWORLD_WALL_CORROCK_CROWN);
        conversions.put(BuiltinDimensionTypes.f_223539_.m_135782_(), EEBlocks.NETHER_WALL_CORROCK_CROWN);
        conversions.put(BuiltinDimensionTypes.f_223540_.m_135782_(), EEBlocks.END_WALL_CORROCK_CROWN);
    });
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)4.5, (double)14.0, (double)16.0, (double)12.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)2.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.5, (double)0.0, (double)2.0, (double)12.5, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)14.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0)));

    public CorrockCrownWallBlock(BlockBehaviour.Properties builder, CorrockCrownBlock.DimensionalType dimensionalType, boolean petrified) {
        super(builder, dimensionalType, petrified);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        Direction facing = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        int xFacingOffset = facing.m_122429_();
        int zFacingOffset = facing.m_122431_();
        double xOffset = (double)((float)xFacingOffset * 0.2f) + CorrockCrownWallBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double yOffset = CorrockCrownWallBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double zOffset = (double)((float)zFacingOffset * 0.2f) + CorrockCrownWallBlock.makeNegativeRandomly(rand.m_188501_() * 0.25f, rand);
        double posX = (double)pos.m_123341_() + 0.5 + xOffset;
        double posY = (double)pos.m_123342_() + 0.5 + yOffset;
        double posZ = (double)pos.m_123343_() + 0.5 + zOffset;
        world.m_7106_((ParticleOptions)new CorrockCrownParticleData(this.dimensionalType.particle.get(), false), posX, posY, posZ, (double)((float)xFacingOffset * -0.01f + rand.m_188501_() * 0.04f - rand.m_188501_() * 0.04f), (double)-0.005f, (double)((float)zFacingOffset * -0.01f + rand.m_188501_() * 0.04f - rand.m_188501_() * 0.04f));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.petrified) {
            Block conversion = this.getConversionBlock((LevelAccessor)level);
            if (conversion == this) {
                return;
            }
            level.m_46597_(pos, (BlockState)conversion.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return Block.m_49863_((LevelReader)world, (BlockPos)blockpos, (Direction)direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        Level iworldreaderbase = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction[] aDirection = context.m_6232_();
        if (this.shouldConvert((LevelAccessor)context.m_43725_())) {
            context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 60 + context.m_43725_().m_213780_().m_188503_(40));
        }
        for (Direction Direction2 : aDirection) {
            Direction Direction1;
            if (!Direction2.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)(Direction1 = Direction2.m_122424_()))).m_60710_((LevelReader)iworldreaderbase, blockpos) || iworldreaderbase.m_8055_(blockpos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60734_() instanceof CorrockCrownWallBlock || iworldreaderbase.m_8055_(blockpos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60734_() instanceof CorrockCrownStandingBlock) continue;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() >= 8));
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            if (!this.petrified) {
                return EEEvents.convertCorrockBlock(stateIn);
            }
        } else if (this.shouldConvert(worldIn)) {
            worldIn.m_186460_(currentPos, (Block)this, 60 + worldIn.m_213780_().m_188503_(40));
        }
        if (facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return facing.m_122424_() == stateIn.m_61143_((Property)FACING) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    protected Block getConversionBlock(LevelAccessor level) {
        return (Block)((Supplier)CONVERSIONS.getOrDefault(((Registry)level.m_9598_().m_6632_(Registries.f_256787_).get()).m_7981_((Object)level.m_6042_()), (Supplier<CorrockCrownWallBlock>)EEBlocks.OVERWORLD_WALL_CORROCK_CROWN)).get();
    }

    private boolean shouldConvert(LevelAccessor level) {
        return !this.petrified && this.getConversionBlock(level) != this;
    }

    private static double makeNegativeRandomly(double value, RandomSource rand) {
        return rand.m_188499_() ? -value : value;
    }

    public ItemStack m_142598_(LevelAccessor p_152719_, BlockPos p_152720_, BlockState p_152721_) {
        return new ItemStack((ItemLike)this);
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }
}

