/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.sounds;

import com.alexander.witherreincarnated.init.SoundEventInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseWitherSoundInstance
extends AbstractTickableSoundInstance {
    protected final WitherBoss mob;
    private boolean hasSwitched;
    private final SoundEvent soundEvent;
    public float targetPitch;

    public BaseWitherSoundInstance(WitherBoss mob, SoundEvent sound, SoundSource source) {
        super(sound, source, SoundInstance.m_235150_());
        this.soundEvent = sound;
        this.mob = mob;
        this.f_119575_ = (float)mob.m_20185_();
        this.f_119576_ = (float)mob.m_20186_();
        this.f_119577_ = (float)mob.m_20189_();
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119574_ = 1.0f;
        this.f_119573_ = 10.0f;
    }

    public void m_7788_() {
        boolean flag = this.shouldSwitchSounds();
        if (flag && !this.m_7801_()) {
            Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)this.getAlternativeSoundInstance());
            this.hasSwitched = true;
        }
        if (this.mob.m_213877_() || this.hasSwitched) {
            this.m_119609_();
        } else {
            this.f_119575_ = this.mob.m_20185_();
            this.f_119576_ = this.mob.m_20186_();
            this.f_119577_ = this.mob.m_20189_();
            if (this.soundEvent == SoundEventInit.WITHER_LOOP_WEAKENED.get()) {
                if (this.mob.m_31502_() > 0) {
                    this.f_119574_ = 0.1f + (1.0f - (float)this.mob.m_31502_() / 220.0f) * 1.9f;
                } else {
                    float max = 1.5f;
                    this.f_119574_ = Math.max(1.0f, max - this.mob.m_21223_() / (this.mob.m_21233_() * 0.6666667f) * max);
                }
            } else if (this.mob.m_217043_().m_188503_(100) == 0) {
                this.targetPitch = 1.0f + (float)(this.mob.m_217043_().m_188583_() * 0.25);
                this.f_119574_ = Mth.m_14179_((float)0.05f, (float)this.f_119574_, (float)this.targetPitch);
            }
            if (this.mob.f_20919_ >= 90) {
                this.f_119573_ = (1.0f - (float)(this.mob.f_20919_ - 90) / 110.0f) * 10.0f;
            }
        }
    }

    public boolean m_7767_() {
        return !this.mob.m_20067_();
    }

    protected abstract AbstractTickableSoundInstance getAlternativeSoundInstance();

    protected abstract boolean shouldSwitchSounds();
}

