/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.network;

import com.alexander.witherreincarnated.events.HandleAnimationsEvent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundStartLaserPacket {
    private final int witherId;
    private final Vec2 angle;

    public ClientboundStartLaserPacket(int witherId, Vec2 angle) {
        this.witherId = witherId;
        this.angle = angle;
    }

    public ClientboundStartLaserPacket(FriendlyByteBuf buf) {
        this.witherId = buf.readInt();
        this.angle = new Vec2(buf.readFloat(), buf.readFloat());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.witherId);
        buf.writeFloat(this.angle.f_82470_);
        buf.writeFloat(this.angle.f_82471_);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            WitherBoss wither;
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.witherId);
            if (entity != null && entity instanceof WitherBoss && HandleAnimationsEvent.witherAnimations.containsKey(wither = (WitherBoss)entity)) {
                HandleAnimationsEvent.WitherAnimations anims = HandleAnimationsEvent.witherAnimations.get(wither);
                anims.laserAngleO = this.angle;
                anims.laserAngle = this.angle;
                anims.laserLength = 0.0f;
            }
        });
        return true;
    }
}

