/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.network;

import com.alexander.witherreincarnated.events.CameraShakeEvents;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundShakeCameraPacket {
    private final int duration;
    private final float amount;
    private final BlockPos causePos;
    private final int range;

    public ClientboundShakeCameraPacket(int duration, float amount, BlockPos causePos, int range) {
        this.duration = duration;
        this.amount = amount;
        this.causePos = causePos;
        this.range = range;
    }

    public ClientboundShakeCameraPacket(FriendlyByteBuf buf) {
        this.duration = buf.readInt();
        this.amount = buf.readFloat();
        this.causePos = buf.m_130135_();
        this.range = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.duration);
        buf.writeFloat(this.amount);
        buf.m_130064_(this.causePos);
        buf.writeInt(this.range);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> CameraShakeEvents.addCameraShake(null, this.duration, this.amount, this.causePos, this.range));
        return true;
    }
}

