/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.mixin;

import com.alexander.witherreincarnated.ai.controllers.wither.WitherNavigation;
import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.enums.CustomBossBarTypes;
import com.alexander.witherreincarnated.events.CameraShakeEvents;
import com.alexander.witherreincarnated.events.HandlePossessedMobsEvent;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.init.TagInit;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherBoss.class})
public abstract class WitherBossMixin
extends Monster
implements PowerableMob,
RangedAttackMob {
    @Shadow
    @Final
    private int[] f_31427_;
    @Shadow
    @Final
    private int[] f_31428_;
    @Shadow
    @Final
    private float[] f_31423_;
    @Shadow
    @Final
    private float[] f_31424_;
    @Shadow
    @Final
    private float[] f_31425_;
    @Shadow
    @Final
    private float[] f_31426_;
    @Shadow
    private final ServerBossEvent f_31430_;
    public boolean powered;
    public int currentHead;
    public long originalTime;
    public boolean built;

    @Shadow
    public abstract int m_31502_();

    @Shadow
    public abstract void m_31510_(int var1);

    @Shadow
    public abstract int m_31512_(int var1);

    @Shadow
    public abstract void m_31454_(int var1, int var2);

    @Shadow
    public abstract void m_31448_(int var1, double var2, double var4, double var6, boolean var8);

    @Shadow
    public abstract void m_31457_(int var1, LivingEntity var2);

    @Shadow
    public abstract float m_31442_(float var1, float var2, float var3);

    @Shadow
    public abstract double m_31514_(int var1);

    @Shadow
    public abstract double m_31516_(int var1);

    @Shadow
    public abstract double m_31518_(int var1);

    protected WitherBossMixin(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_31430_ = (ServerBossEvent)new ServerBossEvent((Component)Component.m_237113_((String)(this.m_5446_().getString() + CustomBossBarTypes.WITHER.tag)), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
        this.originalTime = -1L;
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"}, cancellable=true)
    private void witherreincarnated_stopWitherFromDroppingExperienceEarly(EntityType<? extends WitherBoss> p_31437_, Level p_31438_, CallbackInfo callback) {
        this.f_21364_ = 0;
    }

    @Inject(method={"hurt"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_overrideHurt(DamageSource p_31461_, float p_31462_, CallbackInfoReturnable<Boolean> callback) {
        if (this.m_6673_(p_31461_)) {
            callback.setReturnValue((Object)false);
        } else if (!p_31461_.m_269533_(DamageTypeTags.f_268484_) && p_31461_.m_7639_() != this) {
            if (this.m_31502_() > 0 && !p_31461_.m_269533_(DamageTypeTags.f_268738_)) {
                callback.setReturnValue((Object)false);
            } else {
                Entity entity = p_31461_.m_7640_();
                if (this.m_7090_() && entity instanceof Projectile) {
                    this.m_5496_((SoundEvent)SoundEventInit.WITHER_DEFLECT_SKULL.get(), 2.5f, MiscUtils.randomSoundPitch());
                    callback.setReturnValue((Object)false);
                } else {
                    int i = 0;
                    while (i < this.f_31428_.length) {
                        int n = i++;
                        this.f_31428_[n] = this.f_31428_[n] + 3;
                    }
                    callback.setReturnValue((Object)super.m_6469_(p_31461_, p_31462_));
                }
            }
        } else {
            callback.setReturnValue((Object)false);
        }
        callback.cancel();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    private void witherreincarnated_addWitherSaveData(CompoundTag tag, CallbackInfo callback) {
        tag.m_128356_("SpawnTime", this.originalTime);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")}, cancellable=true)
    private void witherreincarnated_readWitherSaveData(CompoundTag tag, CallbackInfo callback) {
        this.originalTime = tag.m_128454_("SpawnTime");
        this.f_31430_.m_6456_((Component)Component.m_237113_((String)(this.m_5446_().getString() + CustomBossBarTypes.WITHER.tag)));
    }

    @Inject(method={"setCustomName"}, at={@At(value="TAIL")}, cancellable=true)
    private void witherreincarnated_setCustomBossBarOnSetCustomName(@Nullable Component p_31476_, CallbackInfo callback) {
        if (this.m_8077_()) {
            this.f_31430_.m_6456_((Component)Component.m_237113_((String)(this.m_5446_().getString() + CustomBossBarTypes.WITHER.tag)));
        }
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_replaceWitherAmbientSound(CallbackInfoReturnable<SoundEvent> callback) {
        callback.setReturnValue((Object)(this.m_7090_() && this.m_31502_() <= 0 ? (SoundEvent)SoundEventInit.WITHER_IDLE_WEAK.get() : (SoundEvent)SoundEventInit.WITHER_IDLE.get()));
    }

    @Inject(method={"getHurtSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_replaceWitherHurtSound(DamageSource p_31500_, CallbackInfoReturnable<SoundEvent> callback) {
        callback.setReturnValue((Object)((SoundEvent)SoundEventInit.WITHER_HURT.get()));
    }

    @Inject(method={"getDeathSound"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_removeWitherDeathSound(CallbackInfoReturnable<SoundEvent> callback) {
        callback.setReturnValue((Object)((SoundEvent)SoundEventInit.WITHER_HURT.get()));
    }

    @Inject(method={"aiStep"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_overrideAiStep(CallbackInfo callback) {
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        super.m_8107_();
        for (int i = 0; i < 2; ++i) {
            this.f_31426_[i] = this.f_31424_[i];
            this.f_31425_[i] = this.f_31423_[i];
        }
        for (int j = 0; j < 2; ++j) {
            int k = this.m_31512_(j + 1);
            Entity entity1 = null;
            if (k > 0) {
                entity1 = this.m_9236_().m_6815_(k);
            }
            if (entity1 != null) {
                double d9 = this.m_31514_(j + 1);
                double d1 = this.m_31516_(j + 1);
                double d3 = this.m_31518_(j + 1);
                double d4 = entity1.m_20185_() - d9;
                double d5 = entity1.m_20188_() - d1;
                double d6 = entity1.m_20189_() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                this.f_31423_[j] = this.m_31442_(this.f_31423_[j], f1, 40.0f);
                this.f_31424_[j] = this.m_31442_(this.f_31424_[j], f, 10.0f);
                continue;
            }
            this.f_31424_[j] = this.m_31442_(this.f_31424_[j], this.f_20883_, 10.0f);
        }
        boolean flag = this.m_7090_();
        for (int l = 0; l < 3; ++l) {
            double d8 = this.m_31514_(l);
            double d10 = this.m_31516_(l);
            double d2 = this.m_31518_(l);
            this.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123762_, true, d8 + this.f_19796_.m_188583_() * (double)0.3f, d10 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.m_9236_().f_46441_.m_188503_(3) != 0) continue;
            this.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123811_, true, d8 + this.f_19796_.m_188583_() * (double)0.3f, d10 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.m_31502_() > 0) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123811_, true, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * 3.3f), this.m_20189_() + this.f_19796_.m_188583_(), (double)0.7f, (double)0.7f, (double)0.9f);
            }
        }
        if (((Boolean)WRCommonConfig.vanilla_wither_phases.get()).booleanValue()) {
            if (!this.powered && (double)this.m_21223_() <= (double)this.m_21233_() * 0.5) {
                this.powered = true;
            } else if (this.powered && (double)this.m_21223_() > (double)this.m_21233_() * 0.75) {
                this.powered = false;
            }
        } else if (!this.powered && this.m_21223_() <= this.m_21233_() * 0.33333334f) {
            this.powered = true;
        } else if (this.powered && (double)this.m_21223_() > (double)this.m_21233_() * 0.5) {
            this.powered = false;
        }
        callback.cancel();
    }

    @Inject(method={"customServerAiStep"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_overrideCustomServerAiStep(CallbackInfo callback) {
        this.f_19794_ = this.m_5830_();
        if (this.m_31502_() > 0) {
            this.built = true;
            this.m_146922_(this.f_20883_);
            this.m_5616_(this.f_20883_);
            int k1 = this.m_31502_();
            this.f_31430_.m_142711_(1.0f - (float)k1 / 220.0f);
            this.m_21153_(1.0f + this.m_21233_() * (1.0f - (float)k1 / 220.0f));
            if (k1 == 220) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 7.0f, false, Level.ExplosionInteraction.MOB);
                for (LivingEntity livingentity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(16.0), p_33346_ -> p_33346_.m_6084_())) {
                    livingentity.f_19864_ = true;
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 1.0);
                    livingentity.m_5997_(d0 / d2 * 1.0, 1.0, d1 / d2 * 1.0);
                }
            }
            if (k1 <= 1) {
                CameraShakeEvents.addCameraShake(this.m_9236_(), 100, 0.5f, this.m_20183_(), 100);
                this.m_21153_(this.m_21233_());
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
            }
            this.f_31430_.m_6451_(k1 > 1 && (k1 > 80 || k1 / 5 % 2 != 1) ? BossEvent.BossBarColor.BLUE : BossEvent.BossBarColor.PURPLE);
            this.f_31430_.m_6456_((Component)Component.m_237113_((String)(this.m_5446_().getString() + (k1 > 1 && (k1 > 80 || k1 / 5 % 2 != 1) ? CustomBossBarTypes.SPAWNING_WITHER.tag : CustomBossBarTypes.WITHER.tag))));
        } else {
            super.m_8024_();
            if (this.m_20184_() != Vec3.f_82478_) {
                for (int i = 1; i < 3; ++i) {
                    if (this.f_19797_ >= this.f_31427_[i - 1]) {
                        this.currentHead = i;
                        Predicate<LivingEntity> targeting = entity -> !(entity == null || entity.m_6095_().m_204039_(TagInit.EntityTypes.WITHER_WONT_ATTACK) || !this.m_6779_((LivingEntity)entity) || !((double)this.m_20270_((Entity)entity) < 64.0) || HandlePossessedMobsEvent.POSSESSED.test((Entity)entity) || !entity.m_5789_() || this.m_5448_() == entity || this.m_31512_(1) > 0 && this.m_31512_(1) == entity.m_19879_() && this.currentHead != 1 || this.m_31512_(2) > 0 && this.m_31512_(2) == entity.m_19879_() && this.currentHead != 2);
                        int l1 = this.m_31512_(i);
                        if (l1 > 0) {
                            LivingEntity livingentity = (LivingEntity)this.m_9236_().m_6815_(l1);
                            if (targeting.test(livingentity)) {
                                int inaccuracy = livingentity.m_20159_() ? 0 : 4;
                                this.m_31448_(i, livingentity.m_20185_() + this.f_19796_.m_188583_() * (double)inaccuracy, livingentity.m_20188_(), livingentity.m_20189_() + this.f_19796_.m_188583_() * (double)inaccuracy, false);
                                this.f_31427_[i - 1] = this.f_19797_ + 40 + this.f_19796_.m_188503_(60);
                                continue;
                            }
                            this.m_31454_(i, 0);
                            continue;
                        }
                        List list = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(targeting), (LivingEntity)this, this.m_20191_().m_82400_(64.0));
                        if (!list.isEmpty()) {
                            LivingEntity livingentity1 = (LivingEntity)list.get(this.f_19796_.m_188503_(list.size()));
                            this.m_31454_(i, livingentity1.m_19879_());
                        }
                        this.f_31427_[i - 1] = this.f_19797_ + (this.m_7090_() ? 10 + this.f_19796_.m_188503_(20) : 20 + this.f_19796_.m_188503_(40));
                        double d0 = Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.m_20185_() - 10.0), (double)(this.m_20185_() + 10.0));
                        double d1 = this.m_7090_() ? Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.m_20186_() - 2.0), (double)(this.m_20186_() + 1.0)) : Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.m_20186_() - 20.0), (double)(this.m_20186_() + 5.0));
                        double d2 = Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.m_20189_() - 10.0), (double)(this.m_20189_() + 10.0));
                        this.m_31448_(i, d0, d1, d2, false);
                        continue;
                    }
                    if (this.f_31427_[i - 1] - this.f_19797_ > 20) continue;
                    Vec3 shootingFrom = MiscUtils.witherHeadPos((LivingEntity)this, i, true);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        float area = 1.5f;
                        for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
                            ((ServerLevel)this.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(10.0f), Float.valueOf((float)(shootingFrom.f_82479_ + this.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82480_ + this.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82481_ + this.m_217043_().m_188583_() * (double)area))})), true, shootingFrom.f_82479_, shootingFrom.f_82480_, shootingFrom.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (this.m_5448_() != null) {
                    this.m_31454_(0, this.m_5448_().m_19879_());
                } else {
                    this.m_31454_(0, 0);
                }
            }
        }
        if (this.built) {
            this.m_31510_(this.m_31502_() - 1);
        }
        callback.cancel();
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().f_46443_) {
            Level i22;
            if (this.f_19797_ % 10 == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                int j1 = Mth.m_14107_((double)this.m_20186_());
                int i22 = Mth.m_14107_((double)this.m_20185_());
                int j2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                for (int j = -2; j <= 2; ++j) {
                    for (int k2 = -2; k2 <= 2; ++k2) {
                        for (int k = -1; k <= 4; ++k) {
                            int l2 = i22 + j;
                            int l = j1 + k;
                            int i1 = j2 + k2;
                            BlockPos blockpos = new BlockPos(l2, l, i1);
                            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                            if (!blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
                        }
                    }
                }
                if (flag) {
                    this.m_9236_().m_5898_((Player)null, 1022, this.m_20183_(), 0);
                }
            }
            if ((i22 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)i22;
                if (this.originalTime == -1L) {
                    this.originalTime = serverLevel.m_46468_();
                } else if (((Boolean)WRCommonConfig.wither_changes_time.get()).booleanValue()) {
                    long target = MiscUtils.round(Math.max(1L, this.originalTime), 24000L) - 6000L;
                    if (this.f_20919_ >= 90) {
                        float amount = (float)(this.f_20919_ - 90) / 110.0f;
                        serverLevel.m_8615_(MiscUtils.lerpLong(amount, target, this.originalTime));
                    } else {
                        serverLevel.m_8615_(MiscUtils.approachLong(serverLevel.m_46468_(), target, (float)(target - this.originalTime) / 200.0f));
                    }
                    serverLevel.m_7654_().m_6846_().m_11268_((Packet)new ClientboundSetTimePacket(serverLevel.m_46467_(), serverLevel.m_8044_(), false));
                }
            }
            this.f_31430_.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/boss/wither/WitherBoss;performRangedAttack(IDDDZ)V"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_overridePerformRangedAttack(int p_31449_, double p_31450_, double p_31451_, double p_31452_, boolean p_31453_, CallbackInfo callback) {
        if (!this.m_20067_()) {
            this.m_5496_((SoundEvent)SoundEventInit.WITHER_SHOOT.get(), this.m_6121_(), this.m_6100_());
        }
        double d0 = this.m_31514_(p_31449_);
        double d1 = this.m_31516_(p_31449_);
        double d2 = this.m_31518_(p_31449_);
        double d3 = p_31450_ - d0;
        double d4 = p_31451_ - d1;
        double d5 = p_31452_ - d2;
        WitherSkull witherskull = new WitherSkull(this.m_9236_(), (LivingEntity)this, d3, d4, d5);
        witherskull.m_5602_((Entity)this);
        if (p_31453_) {
            witherskull.m_37629_(true);
        }
        witherskull.m_20343_(d0, d1, d2);
        this.m_9236_().m_7967_((Entity)witherskull);
        callback.cancel();
    }

    @Inject(method={"dropCustomDeathLoot"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_cancelNetherStarDrop(DamageSource p_31464_, int p_31465_, boolean p_31466_, CallbackInfo callback) {
        super.m_7472_(p_31464_, p_31465_, p_31466_);
        callback.cancel();
    }

    @Inject(method={"getHeadX"}, at={@At(value="HEAD")}, cancellable=true)
    private void witherreincarnated_overrideHeadX(int head, CallbackInfoReturnable<Double> callback) {
        callback.setReturnValue((Object)MiscUtils.witherHeadPos((LivingEntity)this, (int)head, (boolean)false).f_82479_);
    }

    @Inject(method={"getHeadY"}, at={@At(value="HEAD")}, cancellable=true)
    private void witherreincarnated_overrideHeadY(int head, CallbackInfoReturnable<Double> callback) {
        callback.setReturnValue((Object)MiscUtils.witherHeadPos((LivingEntity)this, (int)head, (boolean)false).f_82480_);
    }

    @Inject(method={"getHeadZ"}, at={@At(value="HEAD")}, cancellable=true)
    private void witherreincarnated_overrideHeadZ(int head, CallbackInfoReturnable<Double> callback) {
        callback.setReturnValue((Object)MiscUtils.witherHeadPos((LivingEntity)this, (int)head, (boolean)false).f_82481_);
    }

    @Inject(method={"createNavigation"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_overrideWitherNavigation(Level p_186262_, CallbackInfoReturnable<PathNavigation> callback) {
        WitherNavigation nav = new WitherNavigation((Mob)this, p_186262_);
        nav.m_26440_(false);
        nav.m_7008_(true);
        nav.m_26443_(true);
        callback.setReturnValue((Object)nav);
    }

    @Inject(method={"isPowered"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_changeArmourTime(CallbackInfoReturnable<Boolean> callback) {
        callback.setReturnValue((Object)this.powered);
    }
}

