/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.attributes;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;

public class CustomAttributeSuppliers {
    public static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> CONFIGURABLE_ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
    public static final Map<EntityType<? extends LivingEntity>, AttributeSupplier> ATTRIBUTE_SUPPLIERS = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();

    public static void populateAttributeSuppliers() {
        CONFIGURABLE_ATTRIBUTES.forEach((type, supplier) -> {
            AttributeSupplier.Builder builder = (AttributeSupplier.Builder)supplier.get();
            AttributeSupplier forgeSupplier = (AttributeSupplier)ForgeHooks.getAttributesView().get(type);
            if (forgeSupplier != null) {
                for (Map.Entry entry : forgeSupplier.f_22241_.entrySet()) {
                    builder.m_22268_((Attribute)entry.getKey(), ((AttributeInstance)entry.getValue()).m_22115_());
                }
            }
            ATTRIBUTE_SUPPLIERS.put((EntityType<? extends LivingEntity>)type, builder.m_22265_());
        });
    }

    public static void addEntity(EntityType<? extends LivingEntity> type, Supplier<AttributeSupplier.Builder> supplier, EntityAttributeCreationEvent event) {
        ImmutableMap.Builder SUPPLIERS_NEW = ImmutableMap.builder();
        DefaultAttributes.f_22294_.forEach((entity, attribute) -> {
            if (entity != type) {
                SUPPLIERS_NEW.put(entity, attribute);
            }
        });
        DefaultAttributes.f_22294_ = SUPPLIERS_NEW.build();
        event.put(type, AttributeSupplier.m_22244_().m_22265_());
        CONFIGURABLE_ATTRIBUTES.put(type, supplier);
    }

    public static void populateConfigurableAttributes(EntityAttributeCreationEvent event) {
        CustomAttributeSuppliers.addEntity((EntityType<? extends LivingEntity>)EntityType.f_20496_, CustomAttributeSuppliers::createWitherAttributes, event);
    }

    public static AttributeSupplier.Builder createWitherAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)WRCommonConfig.wither_health.get()).doubleValue()).m_22268_(Attributes.f_22279_, ((Double)WRCommonConfig.wither_movement_speed.get()).doubleValue()).m_22268_(Attributes.f_22280_, ((Double)WRCommonConfig.wither_movement_speed.get()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.9);
    }
}

