/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.wither;

import com.alexander.witherreincarnated.ai.controllers.wither.WitherMoveControl;
import com.alexander.witherreincarnated.init.TagInit;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.Vec3;

public class WitherRandomTravelGoal
extends Goal {
    public final WitherBoss mob;
    public List<Vec3> previousTargets = Lists.newArrayList();
    public Vec3 targetedPos = Vec3.f_82478_;
    public int nextLocateAreaTime;

    public WitherRandomTravelGoal(WitherBoss mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
        this.targetedPos = mob.m_20182_();
    }

    public boolean m_8036_() {
        if (this.mob.f_19797_ >= this.nextLocateAreaTime) {
            this.findNewTargetedPos();
            return false;
        }
        return !((WitherMoveControl)this.mob.m_21566_()).moving && this.mob.m_217043_().m_188503_(10) == 0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        int distance = 64;
        Vec3 pos = new Vec3(this.targetedPos.f_82479_ + this.mob.m_217043_().m_188583_() * (double)distance, this.mob.m_20186_(), this.targetedPos.f_82481_ + this.mob.m_217043_().m_188583_() * (double)distance);
        this.mob.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.75);
    }

    public void findNewTargetedPos() {
        Vec3 chosenPos = null;
        int distance = 192;
        Vec3 pos = this.targetedPos.m_82520_(this.mob.m_217043_().m_188583_() * (double)distance, 0.0, this.mob.m_217043_().m_188583_() * (double)distance);
        if (this.mob.m_9236_().m_46749_(BlockPos.m_274446_((Position)pos)) && !this.mob.m_9236_().m_204166_(BlockPos.m_274446_((Position)pos)).m_203656_(TagInit.Biomes.WITHER_AVOIDS)) {
            boolean flag = true;
            for (Vec3 previousTarget : this.previousTargets) {
                if (!(PositionUtils.distanceTo(pos, previousTarget) < 96.0f)) continue;
                flag = false;
                break;
            }
            if (flag) {
                chosenPos = pos;
            }
            if (chosenPos != null) {
                this.targetedPos = chosenPos;
                this.previousTargets.add(new Vec3(this.targetedPos.f_82479_, this.targetedPos.f_82480_, this.targetedPos.f_82481_));
                this.nextLocateAreaTime = this.mob.f_19797_ + MiscUtils.randomIntBetween(900, 2100);
            }
        }
    }
}

