/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.wither;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.events.CameraShakeEvents;
import com.alexander.witherreincarnated.events.HandleWitherEvent;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.network.ClientboundStartLaserPacket;
import com.alexander.witherreincarnated.network.ClientboundUpdateLaserPacket;
import com.alexander.witherreincarnated.network.Messages;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class WitherLaserGoal
extends Goal {
    public LivingEntity target;
    public final WitherBoss mob;
    public int nextUseTime = -1;
    public Vec2 laserAngle;
    public Vec2 startAngle;
    public int useTicks;
    public LivingEntity laserTarget = null;
    public final int maxLaserLength;

    public WitherLaserGoal(WitherBoss mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
        this.maxLaserLength = (Integer)WRCommonConfig.max_wither_laser_length.get();
    }

    public boolean m_8036_() {
        if (((Boolean)WRCommonConfig.disable_wither_laser_attack.get()).booleanValue()) {
            return false;
        }
        if (this.nextUseTime == -1) {
            this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_laser_cooldown.get(), (Integer)WRCommonConfig.max_laser_cooldown.get());
        }
        this.laserTarget = this.target = this.mob.m_5448_();
        return this.mob.f_19797_ >= this.nextUseTime && MiscUtils.isEntityValid((Entity)this.laserTarget) && this.mob.m_20270_((Entity)this.laserTarget) < (float)this.maxLaserLength;
    }

    public boolean m_8045_() {
        return this.useTicks <= 200;
    }

    public void m_8056_() {
        this.useTicks = 0;
        this.startAngle = new Vec2(90.0f, PositionUtils.rotationToFace((Vec3)this.shootingFrom(), (Vec3)this.targetPos()).f_82471_);
        this.laserAngle = new Vec2(0.0f, this.mob.f_20883_);
        Messages.sendToAllPlayers(new ClientboundStartLaserPacket(this.mob.m_19879_(), this.laserAngle), this.mob.m_9236_());
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        ++this.useTicks;
        this.mob.m_21573_().m_26573_();
        Vec3 shootingFrom = this.shootingFrom();
        if (this.useTicks >= 60) {
            if (this.useTicks == 60) {
                CameraShakeEvents.addCameraShake(this.mob.m_9236_(), 40, 1.0f, this.mob.m_20183_(), 50);
            }
            LivingEntity laserableMob = this.mob.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(HandleWitherEvent.LIVING_ENTITY_SELECTOR), (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.m_20191_().m_82400_(50.0));
            LivingEntity laserableMobSightIgnoring = this.mob.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26888_(HandleWitherEvent.LIVING_ENTITY_SELECTOR), (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.m_20191_().m_82400_(25.0));
            if (!HandleWitherEvent.LIVING_ENTITY_SELECTOR_PLAYER_ALLOWING.test(this.laserTarget)) {
                if (laserableMob != null) {
                    this.laserTarget = laserableMob;
                } else if (laserableMobSightIgnoring != null) {
                    this.laserTarget = laserableMobSightIgnoring;
                }
            }
            if (HandleWitherEvent.LIVING_ENTITY_SELECTOR_PLAYER_ALLOWING.test(this.target)) {
                this.laserTarget = this.target;
            }
            if (!HandleWitherEvent.LIVING_ENTITY_SELECTOR_PLAYER_ALLOWING.test(this.laserTarget)) {
                this.useTicks = 261;
            }
            float laserLength = this.maxLaserLength;
            Object lastPos = null;
            ArrayList alreadyChecked = Lists.newArrayList();
            List viableTargets = this.mob.m_9236_().m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_((double)((Integer)WRCommonConfig.max_wither_laser_length.get()).intValue()));
            block0: for (float f = 0.0f; f < laserLength; f += 0.25f) {
                Vec3 pos = PositionUtils.getOffsetPos(shootingFrom, 0.0, 0.0, (double)f, this.laserAngle.f_82470_, this.laserAngle.f_82471_);
                if (lastPos != null || !PositionUtils.hasLineOfSight(this.mob.m_9236_(), this.shootingFrom(), pos)) {
                    lastPos = pos;
                    laserLength = PositionUtils.distanceTo(this.shootingFrom(), pos);
                    break;
                }
                if (f >= laserLength - 0.25f) {
                    lastPos = pos;
                }
                for (LivingEntity entity : viableTargets) {
                    if (!entity.m_20191_().m_82390_(pos) || entity == this.mob || !PositionUtils.hasLineOfSight(this.mob.m_9236_(), shootingFrom, entity.m_146892_()) || alreadyChecked.contains(entity)) continue;
                    alreadyChecked.add(entity);
                    entity.m_6469_(this.mob.m_269291_().m_269104_((Entity)this.mob, (Entity)this.mob), ((Double)WRCommonConfig.wither_laser_damage.get()).floatValue());
                    entity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 400, 0), (Entity)this.mob);
                    lastPos = pos;
                    continue block0;
                }
            }
            if ((ForgeEventFactory.getMobGriefingEvent((Level)this.mob.m_9236_(), (Entity)this.mob) || ((Boolean)WRCommonConfig.wither_fire_ignores_mob_griefing.get()).booleanValue()) && ((Boolean)WRCommonConfig.wither_attacks_produce_fire.get()).booleanValue()) {
                AABB aabb = AABB.m_165882_((Vec3)lastPos, (double)0.2, (double)0.2, (double)0.2);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    if (!this.mob.m_9236_().m_8055_(blockpos).m_60795_() || this.mob.m_217043_().m_188503_(3) != 0) continue;
                    this.mob.m_9236_().m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.mob.m_9236_(), (BlockPos)blockpos));
                }
            }
            if (MiscUtils.isEntityValid((Entity)this.laserTarget)) {
                Vec2 targetAngle = PositionUtils.rotationToFace(shootingFrom, this.targetPos());
                float speed = (this.mob.m_7090_() ? 10.0f : 5.0f) / (1.0f + this.mob.m_20270_((Entity)this.laserTarget) / 128.0f * 15.0f);
                this.laserAngle = new Vec2(Mth.m_14148_((float)this.laserAngle.f_82470_, (float)targetAngle.f_82470_, (float)speed), Mth.m_14148_((float)this.laserAngle.f_82471_, (float)targetAngle.f_82471_, (float)speed));
                this.mob.m_146922_(this.laserAngle.f_82471_);
                this.mob.m_5618_(this.laserAngle.f_82471_);
                this.mob.m_5616_(0.0f);
            }
            Messages.sendToAllPlayers(new ClientboundUpdateLaserPacket(this.mob.m_19879_(), this.laserAngle, laserLength), this.mob.m_9236_());
            for (int i = 0; i < 5; ++i) {
                for (ServerPlayer player : ((ServerLevel)this.mob.m_9236_()).m_6907_()) {
                    ((ServerLevel)this.mob.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(5.0f), Float.valueOf((float)shootingFrom.f_82479_), Float.valueOf((float)shootingFrom.f_82480_), Float.valueOf((float)shootingFrom.f_82481_)})), true, shootingFrom.f_82479_ + this.mob.m_217043_().m_188583_(), shootingFrom.f_82480_ + this.mob.m_217043_().m_188583_(), shootingFrom.f_82481_ + this.mob.m_217043_().m_188583_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        } else {
            float turnSpeed = 1.0f;
            this.laserAngle = new Vec2(Mth.m_14148_((float)this.laserAngle.f_82470_, (float)this.startAngle.f_82470_, (float)turnSpeed), Mth.m_14148_((float)this.laserAngle.f_82471_, (float)this.startAngle.f_82471_, (float)turnSpeed));
            float f = this.laserAngle.f_82471_;
            this.mob.m_146922_(f);
            this.mob.m_5618_(f);
            this.mob.m_5616_(0.0f);
            Messages.sendToAllPlayers(new ClientboundUpdateLaserPacket(this.mob.m_19879_(), this.laserAngle, 0.0f), this.mob.m_9236_());
            for (int i = 0; i < 15; ++i) {
                for (ServerPlayer player : ((ServerLevel)this.mob.m_9236_()).m_6907_()) {
                    ((ServerLevel)this.mob.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(10.0f), Float.valueOf((float)(shootingFrom.f_82479_ + this.mob.m_217043_().m_188583_() * 5.0)), Float.valueOf((float)(shootingFrom.f_82480_ + this.mob.m_217043_().m_188583_() * 5.0)), Float.valueOf((float)(shootingFrom.f_82481_ + this.mob.m_217043_().m_188583_() * 5.0))})), true, shootingFrom.f_82479_, shootingFrom.f_82480_, shootingFrom.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Vec3 shootingFrom() {
        return this.laserAngle == null ? PositionUtils.getOffsetPos(this.mob.m_20182_().m_82520_(0.0, (double)this.mob.m_20206_() * 0.5, 0.0), 0.0, 0.0, (double)this.mob.m_20205_() * 0.5, this.mob.m_146909_(), this.mob.f_20885_) : PositionUtils.getOffsetPos(this.mob.m_20182_().m_82520_(0.0, (double)this.mob.m_20206_() * 0.5, 0.0), 0.0, 0.0, (double)this.mob.m_20205_() * 0.5, this.laserAngle.f_82470_, this.laserAngle.f_82471_);
    }

    public Vec3 targetPos() {
        return this.laserTarget.m_20182_().m_82520_(0.0, (double)this.laserTarget.m_20206_() * 0.25, 0.0);
    }

    public void m_8041_() {
        this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_laser_cooldown.get(), (Integer)WRCommonConfig.max_laser_cooldown.get());
        Messages.sendToAllPlayers(new ClientboundUpdateLaserPacket(this.mob.m_19879_(), Vec2.f_82462_, 0.0f), this.mob.m_9236_());
    }
}

