/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.wither;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.network.ClientboundWitherStartAnimationPacket;
import com.alexander.witherreincarnated.network.Messages;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.Vec3;

public class WitherChargeGoal
extends Goal {
    public LivingEntity target;
    public final WitherBoss mob;
    public int nextUseTime = -1;
    public Vec3 changeMotion;
    public int useTicks;
    public float targetRot;
    public List<Entity> alreadyHit = Lists.newArrayList();
    public int stunTime;
    public Vec3 chargingFrom;

    public WitherChargeGoal(WitherBoss mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
    }

    public boolean m_8036_() {
        if (((Boolean)WRCommonConfig.disable_wither_charge_attack.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)WRCommonConfig.vanilla_wither_phases.get()).booleanValue() && this.mob.m_21223_() <= this.mob.m_21233_() * 0.6666667f && this.nextUseTime == -1) {
            this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_charge_cooldown.get(), (Integer)WRCommonConfig.max_charge_cooldown.get());
        }
        this.target = this.mob.m_5448_();
        return this.mob.f_19797_ >= this.nextUseTime && MiscUtils.isEntityValid((Entity)this.target) && (this.mob.m_21223_() <= this.mob.m_21233_() * 0.6666667f || (Boolean)WRCommonConfig.vanilla_wither_phases.get() != false);
    }

    public boolean m_8045_() {
        return this.useTicks <= 80 || this.stunTime > 0;
    }

    public void m_8056_() {
        this.useTicks = 0;
        this.stunTime = 0;
        this.alreadyHit.clear();
        Vec3 targetPos = this.target.m_20182_();
        Vec3 myPos = this.mob.m_20182_();
        double dist = Math.max(PositionUtils.distanceTo(myPos, targetPos), 1.0f);
        Vec3 multiplier = this.mob.m_7090_() ? new Vec3(0.135, 0.4, 0.135) : new Vec3(0.1, 0.0, 0.1);
        this.changeMotion = new Vec3((targetPos.f_82479_ - myPos.f_82479_) / dist, (targetPos.f_82480_ - myPos.f_82480_) / dist, (targetPos.f_82481_ - myPos.f_82481_) / dist).m_82559_(multiplier);
        this.targetRot = PositionUtils.rotationToFace((Vec3)myPos, (Vec3)targetPos).f_82471_;
        Messages.sendToAllPlayers(new ClientboundWitherStartAnimationPacket(this.mob.m_19879_(), 0), this.mob.m_9236_());
        this.mob.m_5496_((SoundEvent)SoundEventInit.WITHER_CHARGE.get(), 7.5f, 1.0f);
        this.chargingFrom = this.mob.m_20182_();
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        ++this.useTicks;
        this.mob.m_21573_().m_26573_();
        if (this.useTicks >= 20) {
            this.mob.m_146922_(this.targetRot);
            this.mob.m_5618_(this.targetRot);
            if (this.stunTime <= 0) {
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(this.changeMotion));
                for (LivingEntity entity : this.mob.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_148355_().m_26893_(), (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(1.5))) {
                    if (this.alreadyHit.contains(entity)) continue;
                    entity.f_19864_ = true;
                    entity.m_5997_(this.mob.m_20184_().f_82479_, this.mob.m_20184_().f_82480_, this.mob.m_20184_().f_82481_);
                    DamageSource source = this.mob.m_269291_().m_269333_((LivingEntity)this.mob);
                    source.f_268454_ = this.chargingFrom;
                    boolean flag = entity.m_6469_(source, ((Double)WRCommonConfig.wither_charge_damage.get()).floatValue());
                    if (flag) {
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 1));
                    } else {
                        this.stunTime = 80;
                        this.mob.m_5496_((SoundEvent)SoundEventInit.WITHER_STUN.get(), 7.5f, 1.0f);
                        Messages.sendToAllPlayers(new ClientboundWitherStartAnimationPacket(this.mob.m_19879_(), 1), this.mob.m_9236_());
                    }
                    MiscUtils.disableShield(entity, (Integer)WRCommonConfig.charge_disable_shield_time.get());
                    this.alreadyHit.add((Entity)entity);
                }
            } else {
                this.mob.m_20256_(Vec3.f_82478_);
                --this.stunTime;
                if (this.stunTime == 0) {
                    for (LivingEntity livingentity : this.mob.m_9236_().m_6443_(LivingEntity.class, this.mob.m_20191_().m_82400_(16.0), p_33346_ -> p_33346_ != this.mob && p_33346_.m_6084_())) {
                        livingentity.f_19864_ = true;
                        livingentity.m_6853_(false);
                        double d0 = livingentity.m_20185_() - this.mob.m_20185_();
                        double d1 = livingentity.m_20189_() - this.mob.m_20189_();
                        double d2 = Math.max(d0 * d0 + d1 * d1, 1.0);
                        livingentity.m_5997_(d0 / d2 * 25.0, 1.25, d1 / d2 * 25.0);
                    }
                }
            }
        } else {
            float turnSpeed = 16.0f;
            float f9 = Mth.m_14148_((float)this.mob.f_20883_, (float)this.targetRot, (float)turnSpeed);
            this.mob.m_146922_(f9);
            this.mob.m_5618_(f9);
        }
    }

    public void m_8041_() {
        this.nextUseTime = this.mob.f_19797_ + (this.mob.m_7090_() ? MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_charge_cooldown_final_phase.get(), (Integer)WRCommonConfig.max_charge_cooldown_final_phase.get()) : MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_charge_cooldown.get(), (Integer)WRCommonConfig.max_charge_cooldown.get()));
    }
}

