/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs.structures.jisaw;

import com.github.dodo.dodosmobs.DodosMobs;
import com.github.dodo.dodosmobs.mixin.accessor.StructureTemplatePoolAccessor;
import com.github.dodo.dodosmobs.structures.jisaw.assembler.JigsawStructureAssembler;
import com.github.dodo.dodosmobs.structures.jisaw.context.StructureContext;
import com.github.dodo.dodosmobs.structures.jisaw.element.CataclysmJigsawPoolElement;
import com.github.dodo.dodosmobs.util.BoxOctree;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;

public class JigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext generationContext, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawNameOptional, int maxDepth, BlockPos locatePos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY) {
        RegistryAccess registryAccess = generationContext.f_226621_();
        ChunkGenerator chunkGenerator = generationContext.f_226622_();
        StructureTemplateManager structureManager = generationContext.f_226625_();
        LevelHeightAccessor levelHeightAccessor = generationContext.f_226629_();
        WorldgenRandom worldgenRandom = generationContext.f_226626_();
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        Optional<PoolElementStructurePiece> startPieceOptional = JigsawManager.getStartPiece(startPool, startJigsawNameOptional, locatePos, structureManager, (RandomSource)worldgenRandom);
        if (startPieceOptional.isEmpty()) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = startPieceOptional.get();
        BlockPos startingPosOffset = locatePos.m_121996_((Vec3i)startPiece.m_72646_());
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int bbCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int bbCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int bbCenterY = projectStartToHeightmap.map(types -> locatePos.m_123342_() + chunkGenerator.m_223221_(bbCenterX, bbCenterZ, types, levelHeightAccessor, generationContext.f_226624_())).orElseGet(() -> startPiece.m_72646_().m_123342_());
        int adjustedPieceCenterY = bbCenterY + startingPosOffset.m_123342_();
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, bbCenterY - yAdjustment, 0);
        AABB aABB = new AABB((double)(bbCenterX - maxDistanceFromCenter), (double)(adjustedPieceCenterY - maxDistanceFromCenter), (double)(bbCenterZ - maxDistanceFromCenter), (double)(bbCenterX + maxDistanceFromCenter + 1), (double)(adjustedPieceCenterY + maxDistanceFromCenter + 1), (double)(bbCenterZ + maxDistanceFromCenter + 1));
        BoxOctree maxStructureBounds = new BoxOctree(aABB);
        maxStructureBounds.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
        return Optional.of(new Structure.GenerationStub(new BlockPos(bbCenterX, adjustedPieceCenterY, bbCenterZ), structurePiecesBuilder -> {
            if (maxDepth <= 0) {
                return;
            }
            JigsawStructureAssembler assembler = new JigsawStructureAssembler(new JigsawStructureAssembler.Settings().poolRegistry((Registry<StructureTemplatePool>)registry).maxDepth(maxDepth).chunkGenerator(chunkGenerator).structureTemplateManager(structureManager).randomState(generationContext.f_226624_()).rand((RandomSource)worldgenRandom).maxY(maxY).minY(minY).useExpansionHack(useExpansionHack).levelHeightAccessor(levelHeightAccessor));
            assembler.assembleStructure(startPiece, maxStructureBounds);
            assembler.addAllPiecesToStructureBuilder((StructurePiecesBuilder)structurePiecesBuilder);
        }));
    }

    private static Optional<PoolElementStructurePiece> getStartPiece(Holder<StructureTemplatePool> startPoolHolder, Optional<ResourceLocation> startJigsawNameOptional, BlockPos locatePos, StructureTemplateManager structureTemplateManager, RandomSource rand) {
        int chosenPieceWeight;
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.m_203334_();
        ObjectArrayList candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)startPool).getRawTemplates());
        Util.m_214673_((ObjectArrayList)candidatePoolElements, (RandomSource)rand);
        Rotation rotation = Rotation.m_221990_((RandomSource)rand);
        for (int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum); candidatePoolElements.size() > 0 && totalWeightSum > 0; totalWeightSum -= chosenPieceWeight) {
            StructureContext ctx;
            CataclysmJigsawPoolElement yungElement;
            BlockPos anchorPos;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                CataclysmJigsawPoolElement yungElement2;
                StructurePoolElement candidatePiece = (StructurePoolElement)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof CataclysmJigsawPoolElement) || !(yungElement2 = (CataclysmJigsawPoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = rand.m_188503_(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            StructurePoolElement chosenPoolElement = (StructurePoolElement)chosenPoolElementPair.getFirst();
            chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == EmptyPoolElement.f_210175_) {
                return Optional.empty();
            }
            if (startJigsawNameOptional.isPresent()) {
                ResourceLocation name = startJigsawNameOptional.get();
                Optional<BlockPos> optional = JigsawManager.getPosOfJigsawBlockWithName(chosenPoolElement, name, locatePos, rotation, structureTemplateManager, rand);
                if (optional.isEmpty()) {
                    DodosMobs.LOGGER.error("No starting jigsaw with Name {} found in start pool {}", (Object)name, (Object)startPoolHolder.m_203543_().map(pool -> pool.m_135782_().toString()).orElse("<unregistered>"));
                    return Optional.empty();
                }
                anchorPos = optional.get();
            } else {
                anchorPos = locatePos;
            }
            BlockPos startingPosOffset = anchorPos.m_121996_((Vec3i)locatePos);
            BlockPos adjustedStartPos = locatePos.m_121996_((Vec3i)startingPosOffset);
            if (chosenPoolElement instanceof CataclysmJigsawPoolElement && !(yungElement = (CataclysmJigsawPoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureTemplateManager(structureTemplateManager).pos(adjustedStartPos).rotation(rotation).depth(0).random(rand).build())) {
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            return Optional.of(new PoolElementStructurePiece(structureTemplateManager, chosenPoolElement, adjustedStartPos, chosenPoolElement.m_210540_(), rotation, chosenPoolElement.m_214015_(structureTemplateManager, adjustedStartPos, rotation)));
        }
        return Optional.empty();
    }

    private static Optional<BlockPos> getPosOfJigsawBlockWithName(StructurePoolElement structurePoolElement, ResourceLocation name, BlockPos startPos, Rotation rotation, StructureTemplateManager structureTemplateManager, RandomSource rand) {
        try {
            List shuffledJigsawBlocks = structurePoolElement.m_213638_(structureTemplateManager, startPos, rotation, rand);
            for (StructureTemplate.StructureBlockInfo jigsawBlockInfo : shuffledJigsawBlocks) {
                ResourceLocation jigsawBlockName = ResourceLocation.m_135820_((String)jigsawBlockInfo.f_74677_().m_128461_("name"));
                if (!name.equals((Object)jigsawBlockName)) continue;
                return Optional.of(jigsawBlockInfo.f_74675_());
            }
        }
        catch (ConcurrentModificationException e) {
            DodosMobs.LOGGER.error("Encountered unexpected ConcurrentModException while trying to get jigsaw block with name {} from structure pool element {}", (Object)name, (Object)structurePoolElement);
            DodosMobs.LOGGER.error("Ignoring - the structure will still generate, but /locate will not point to the structure's anchor block.");
            return Optional.empty();
        }
        return Optional.empty();
    }
}

