/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs.config;

import com.github.L_Ender.lionfishapi.config.biome.SpawnBiomeConfig;
import com.github.L_Ender.lionfishapi.config.biome.SpawnBiomeData;
import com.github.dodo.dodosmobs.DodosMobs;
import com.github.dodo.dodosmobs.config.DefaultBiomes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeConfig {
    public static final Pair<String, SpawnBiomeData> deepling = Pair.of((Object)"cataclysm:deepling_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> deepling_angler = Pair.of((Object)"cataclysm:deepling_angler_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> coral_golem = Pair.of((Object)"cataclysm:coral_golem_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> deepling_brute = Pair.of((Object)"cataclysm:deepling_brute_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> deepling_priest = Pair.of((Object)"cataclysm:deepling_priest_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> deepling_warlock = Pair.of((Object)"cataclysm:deepling_warlock_spawns", (Object)DefaultBiomes.DEEPLING);
    public static final Pair<String, SpawnBiomeData> amethyst_crab = Pair.of((Object)"cataclysm:amethyst_crab_spawns", (Object)DefaultBiomes.CRAB);
    public static final Pair<String, SpawnBiomeData> koboleton = Pair.of((Object)"cataclysm:koboleton_spawns", (Object)DefaultBiomes.KOBOLETON);
    private static boolean init = false;
    private static final Map<String, SpawnBiomeData> biomeConfigValues = new HashMap<String, SpawnBiomeData>();

    public static void init() {
        try {
            for (Field f : BiomeConfig.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Pair)) continue;
                String id = (String)((Pair)obj).getLeft();
                SpawnBiomeData data = (SpawnBiomeData)((Pair)obj).getRight();
                biomeConfigValues.put(id, SpawnBiomeConfig.create((ResourceLocation)new ResourceLocation(id), (SpawnBiomeData)data));
            }
        }
        catch (Exception e) {
            DodosMobs.LOGGER.warn("Encountered error building cataclysm biome config .json files");
            e.printStackTrace();
        }
        init = true;
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome, ResourceLocation name) {
        if (!init) {
            return false;
        }
        return biomeConfigValues.get(entry.getKey()).matches(biome, name);
    }

    public static boolean test(Pair<String, SpawnBiomeData> spawns, Holder<Biome> biome) {
        return BiomeConfig.test(spawns, biome, ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.m_203334_())));
    }
}

