/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs;

import com.github.dodo.dodosmobs.ClientProxy;
import com.github.dodo.dodosmobs.CommonProxy;
import com.github.dodo.dodosmobs.client.model.CMModelLayers;
import com.github.dodo.dodosmobs.config.DoConfig;
import com.github.dodo.dodosmobs.config.DodoMobs_Config;
import com.github.dodo.dodosmobs.event.ServerEventHandler;
import com.github.dodo.dodosmobs.init.ModBlocks;
import com.github.dodo.dodosmobs.init.ModEffect;
import com.github.dodo.dodosmobs.init.ModEntities;
import com.github.dodo.dodosmobs.init.ModGroup;
import com.github.dodo.dodosmobs.init.ModItems;
import com.github.dodo.dodosmobs.init.ModJigsaw;
import com.github.dodo.dodosmobs.init.ModParticle;
import com.github.dodo.dodosmobs.init.ModSounds;
import com.github.dodo.dodosmobs.init.ModStructurePlacementType;
import com.github.dodo.dodosmobs.init.ModStructureProcessor;
import com.github.dodo.dodosmobs.init.ModStructures;
import com.github.dodo.dodosmobs.init.ModTileentites;
import com.github.dodo.dodosmobs.message.MessageCMMultipart;
import com.github.dodo.dodosmobs.message.MessageMusic;
import com.github.dodo.dodosmobs.message.MessageUpdateBossBar;
import com.github.dodo.dodosmobs.world.DodoMobSpawnBiomeModifier;
import com.github.dodo.dodosmobs.world.DodoMobSpawnStructureModifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dodosmobs")
@Mod.EventBusSubscriber(modid="dodosmobs")
public class DodosMobs {
    public static final String MODID = "dodosmobs";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleChannel NETWORK_WRAPPER;
    private static final String PROTOCOL_VERSION;
    public static CommonProxy PROXY;
    private static int packetsRegistered;

    public DodosMobs() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DodoMobs_Config.COMMON_SPEC, "dodo-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DodoMobs_Config.CLIENT_SPEC, "dodo-client.toml");
        bus.addListener(this::setup);
        bus.addListener(this::setupClient);
        ModGroup.DEF_REG.register(bus);
        bus.addListener(this::setupEntityModelLayers);
        ModItems.ITEMS.register(bus);
        ModEffect.EFFECTS.register(bus);
        ModBlocks.BLOCKS.register(bus);
        ModParticle.PARTICLE.register(bus);
        ModStructures.STRUCTURE_PIECE_DEF_REG.register(bus);
        ModStructures.STRUCTURE_TYPE_DEF_REG.register(bus);
        ModTileentites.TILE_ENTITY_TYPES.register(bus);
        ModEntities.ENTITY_TYPE.register(bus);
        ModSounds.SOUNDS.register(bus);
        ModStructurePlacementType.STRUCTURE_PLACEMENT_TYPE.register(bus);
        ModStructureProcessor.STRUCTURE_PROCESSOR.register(bus);
        PROXY.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        biomeModifiers.register(bus);
        biomeModifiers.register("dodo_mob_spawns", DodoMobSpawnBiomeModifier::makeCodec);
        DeferredRegister structureModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)MODID);
        structureModifiers.register(bus);
        structureModifiers.register("dodo_structure_spawns", DodoMobSpawnStructureModifier::makeCodec);
    }

    private void setupEntityModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        CMModelLayers.register(event);
    }

    @SubscribeEvent
    public void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == DodoMobs_Config.COMMON_SPEC) {
            DoConfig.bake(config);
        }
    }

    public static <MSG> void sendMSGToServer(MSG message) {
        NETWORK_WRAPPER.sendToServer(message);
    }

    public static <MSG> void sendMSGToAll(MSG message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            DodosMobs.sendNonLocal(message, player);
        }
    }

    public static <MSG> void sendNonLocal(MSG msg, ServerPlayer player) {
        NETWORK_WRAPPER.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private void setupClient(FMLClientSetupEvent event) {
        PROXY.clientInit();
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageCMMultipart.class, MessageCMMultipart::encode, MessageCMMultipart::new, MessageCMMultipart.Handler::onMessage);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageUpdateBossBar.class, MessageUpdateBossBar::write, MessageUpdateBossBar::read, MessageUpdateBossBar::handle);
        NETWORK_WRAPPER.registerMessage(packetsRegistered++, MessageMusic.class, MessageMusic::write, MessageMusic::read, MessageMusic.Handler::onMessage);
        event.enqueueWork(ModItems::initDispenser);
        event.enqueueWork(ModJigsaw::registerJigsawElements);
    }

    static {
        PROTOCOL_VERSION = Integer.toString(1);
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        NetworkRegistry.ChannelBuilder channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main_channel"));
        String version = PROTOCOL_VERSION;
        version.getClass();
        channel = channel.clientAcceptedVersions(version::equals);
        version = PROTOCOL_VERSION;
        version.getClass();
        NETWORK_WRAPPER = channel.serverAcceptedVersions(version::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

