/*
 * Decompiled with CFR 0.152.
 */
package com.github.dodo.dodosmobs;

import com.github.dodo.dodosmobs.CommonProxy;
import com.github.dodo.dodosmobs.DodosMobs;
import com.github.dodo.dodosmobs.client.event.ClientEvent;
import com.github.dodo.dodosmobs.client.particle.CustomExplodeParticle;
import com.github.dodo.dodosmobs.client.particle.LightTrailParticle;
import com.github.dodo.dodosmobs.client.particle.LightningParticle;
import com.github.dodo.dodosmobs.client.particle.RingParticle;
import com.github.dodo.dodosmobs.client.particle.StormParticle;
import com.github.dodo.dodosmobs.client.particle.TrackLightningParticle;
import com.github.dodo.dodosmobs.client.render.DodoItemstackRenderer;
import com.github.dodo.dodosmobs.client.render.entity.Bone_Chimera_Hand_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.Bone_Chimera_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.Cm_Falling_Block_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.Dead_Horn_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.Lizardman_Guardian_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.Mecha_Dino_Renderer;
import com.github.dodo.dodosmobs.client.render.entity.RendererNull;
import com.github.dodo.dodosmobs.client.render.item.CustomArmorRenderProperties;
import com.github.dodo.dodosmobs.client.render.item.DodoItemRenderProperties;
import com.github.dodo.dodosmobs.init.ModEntities;
import com.github.dodo.dodosmobs.init.ModParticle;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="dodosmobs", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final Int2ObjectMap<AbstractTickableSoundInstance> ENTITY_SOUND_INSTANCE_MAP = new Int2ObjectOpenHashMap();
    public static final Map<BlockEntity, AbstractTickableSoundInstance> BLOCK_ENTITY_SOUND_INSTANCE_MAP = new HashMap<BlockEntity, AbstractTickableSoundInstance>();
    public static Map<UUID, Integer> bossBarRenderTypes = new HashMap<UUID, Integer>();
    public static List<UUID> blockedEntityRenders = new ArrayList<UUID>();

    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupParticles);
    }

    public void setupParticles(RegisterParticleProvidersEvent registry) {
        DodosMobs.LOGGER.debug("Registered particle factories");
        registry.registerSpecial((ParticleType)ModParticle.LIGHTNING.get(), (ParticleProvider)new LightningParticle.OrbFactory());
        registry.registerSpecial((ParticleType)ModParticle.TRACK_LIGHTNING.get(), (ParticleProvider)new TrackLightningParticle.OrbFactory());
        registry.registerSpecial((ParticleType)ModParticle.STORM.get(), (ParticleProvider)new StormParticle.OrbFactory());
        registry.registerSpriteSet((ParticleType)ModParticle.RING.get(), RingParticle.RingFactory::new);
        registry.registerSpecial((ParticleType)ModParticle.LIGHT_TRAIL.get(), (ParticleProvider)new LightTrailParticle.OrbFactory());
        registry.registerSpriteSet((ParticleType)ModParticle.FLARE_EXPLODE.get(), CustomExplodeParticle.FlareFactory::new);
    }

    @Override
    public void clientInit() {
        ItemRenderer itemRendererIn = Minecraft.m_91087_().m_91291_();
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SCREEN_SHAKE.get()), RendererNull::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.ACCRETION.get()), RendererNull::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BONE_CHIMERA.get()), Bone_Chimera_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.MECHA_DINO.get()), Mecha_Dino_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.DEAD_HORN.get()), Dead_Horn_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.LIZARDMAN_GUARDIAN.get()), Lizardman_Guardian_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.BONE_CHIMERA_HAND.get()), Bone_Chimera_Hand_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.CM_FALLING_BLOCK.get()), Cm_Falling_Block_Renderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WITHERBREATH.get()), RendererNull::new);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvent());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Callable<BlockEntityWithoutLevelRenderer> getTEISR() {
        return DodoItemstackRenderer::new;
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void blockRenderingEntity(UUID id) {
        blockedEntityRenders.add(id);
    }

    @Override
    public void releaseRenderingEntity(UUID id) {
        blockedEntityRenders.remove(id);
    }

    @Override
    public boolean isFirstPersonPlayer(Entity entity) {
        return entity.equals((Object)Minecraft.m_91087_().f_91075_) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
    }

    @Override
    public Object getISTERProperties() {
        return new DodoItemRenderProperties();
    }

    @Override
    public Object getArmorRenderProperties() {
        return new CustomArmorRenderProperties();
    }

    @Override
    public void clearSoundCacheFor(Entity entity) {
        ENTITY_SOUND_INSTANCE_MAP.remove(entity.m_19879_());
    }

    @Override
    public void clearSoundCacheFor(BlockEntity entity) {
        BLOCK_ENTITY_SOUND_INSTANCE_MAP.remove(entity);
    }

    @Override
    public float getPartialTicks() {
        return Minecraft.m_91087_().getPartialTick();
    }

    @Override
    public void playWorldSound(@Nullable Object soundEmitter, byte type) {
        if (soundEmitter instanceof Entity) {
            Entity entity = (Entity)soundEmitter;
            if (!entity.m_9236_().f_46443_) {
                return;
            }
        }
    }

    @Override
    public void removeBossBarRender(UUID bossBar) {
        bossBarRenderTypes.remove(bossBar);
    }

    @Override
    public void setBossBarRender(UUID bossBar, int renderType) {
        bossBarRenderTypes.put(bossBar, renderType);
    }
}

