/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.core.data.BMWorldSavedData;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.event.SoulNetworkEvent;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class NetworkHelper {
    @Nullable
    private static BMWorldSavedData dataHandler;

    public static SoulNetwork getSoulNetwork(String uuid) {
        if (dataHandler == null) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return null;
            }
            DimensionDataStorage savedData = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
            dataHandler = (BMWorldSavedData)savedData.m_164861_(BMWorldSavedData::load, () -> new BMWorldSavedData(), "BloodMagic-SoulNetworks");
        }
        return dataHandler.getNetwork(UUID.fromString(uuid));
    }

    public static SoulNetwork getSoulNetwork(UUID uuid) {
        return NetworkHelper.getSoulNetwork(uuid.toString());
    }

    public static SoulNetwork getSoulNetwork(Player player) {
        return NetworkHelper.getSoulNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public static SoulNetwork getSoulNetwork(Binding binding) {
        return NetworkHelper.getSoulNetwork(binding.getOwnerId());
    }

    public static int getCurrentMaxOrb(SoulNetwork soulNetwork) {
        return soulNetwork.getOrbTier();
    }

    public static int getMaximumForTier(int tier) {
        int ret = 0;
        if (tier > OrbRegistry.getTierMap().size() || tier < 0) {
            return ret;
        }
        for (ItemStack orbStack : OrbRegistry.getOrbsForTier(tier)) {
            BloodOrb orb = ((IBloodOrb)orbStack.m_41720_()).getOrb(orbStack);
            if (orb.getCapacity() <= ret) continue;
            ret = orb.getCapacity();
        }
        return ret;
    }

    @Deprecated
    public static boolean syphonAndDamage(SoulNetwork soulNetwork, Player user, int toSyphon) {
        return soulNetwork.syphonAndDamage(user, toSyphon);
    }

    public static boolean syphonFromContainer(ItemStack stack, SoulTicket ticket) {
        if (!(stack.m_41720_() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.m_41720_()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        SoulNetworkEvent.Syphon.Item event = new SoulNetworkEvent.Syphon.Item(network, ticket, stack);
        return !MinecraftForge.EVENT_BUS.post((Event)event) && network.syphon(event.getTicket(), true) >= ticket.getAmount();
    }

    public static boolean canSyphonFromContainer(ItemStack stack, int toSyphon) {
        if (!(stack.m_41720_() instanceof IBindable)) {
            return false;
        }
        Binding binding = ((IBindable)stack.m_41720_()).getBinding(stack);
        if (binding == null) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
        if (network == null) {
            return false;
        }
        return network.getCurrentEssence() >= toSyphon;
    }

    public static void setMaxOrb(SoulNetwork soulNetwork, int maxOrb) {
        soulNetwork.setOrbTier(Math.max(maxOrb, soulNetwork.getOrbTier()));
    }

    public static BlockPos getSpawnPositionOfDungeon() {
        if (dataHandler == null) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return null;
            }
            DimensionDataStorage savedData = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
            dataHandler = (BMWorldSavedData)savedData.m_164861_(BMWorldSavedData::load, () -> new BMWorldSavedData(), "BloodMagic-SoulNetworks");
        }
        int currentNumberOfDungeons = dataHandler.getNumberOfDungeons();
        double dungeonIndex = currentNumberOfDungeons + 1;
        int gridIndexSize = (int)Math.ceil((Math.sqrt(dungeonIndex) - 1.0) / 2.0);
        int ringPlacementIndex = currentNumberOfDungeons;
        if (gridIndexSize > 0) {
            ringPlacementIndex -= (2 * (gridIndexSize - 1) + 1) * (2 * (gridIndexSize - 1) + 1);
        }
        for (int i = -gridIndexSize; i <= gridIndexSize; ++i) {
            for (int j = -gridIndexSize; j <= gridIndexSize; ++j) {
                if (Math.abs(i) != gridIndexSize && Math.abs(j) != gridIndexSize) continue;
                if (ringPlacementIndex == 0) {
                    return new BlockPos(i * 1000, 128, j * 1000);
                }
                --ringPlacementIndex;
            }
        }
        return BlockPos.f_121853_;
    }

    public static void incrementDungeonCounter() {
        int currentNumberOfDungeons = dataHandler.getNumberOfDungeons();
        dataHandler.setNumberOfDungeons(currentNumberOfDungeons + 1);
        dataHandler.m_77762_();
    }

    @SubscribeEvent
    public static void resetDatahandler(ServerStoppedEvent event) {
        dataHandler = null;
    }
}

