/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.entity.projectile.EntityMeteor;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeMeteor;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="meteor")
public class RitualMeteor
extends Ritual {
    public static final String CHECK_RANGE = "itemRange";

    public RitualMeteor() {
        super("ritualMeteor", 0, 250000, "ritual.bloodmagic.meteorRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 1, 1));
        this.setMaximumVolumeAndDistanceOfRange(CHECK_RANGE, 27, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        if (world.f_46443_) {
            return;
        }
        AreaDescriptor itemRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List itemList = world.m_45976_(ItemEntity.class, itemRange.getAABB(masterRitualStone.getMasterBlockPos()));
        for (ItemEntity entityItem : itemList) {
            if (!entityItem.m_6084_()) continue;
            ItemStack stack = entityItem.m_32055_();
            RecipeMeteor recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getMeteor(world, stack);
            if (recipe == null) continue;
            int syphonAmount = recipe.getSyphon();
            int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
            if (currentEssence < syphonAmount) {
                return;
            }
            if (syphonAmount > 0) {
                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(syphonAmount));
            }
            EntityMeteor meteor = new EntityMeteor(world, (double)masterRitualStone.getMasterBlockPos().m_123341_() + 0.5, world.m_151558_() + 10, (double)masterRitualStone.getMasterBlockPos().m_123343_() + 0.5);
            meteor.m_6001_(0.0, -0.1, 0.0);
            meteor.setContainedStack(stack.m_41620_(1));
            world.m_7967_((Entity)meteor);
            if (stack.m_41619_()) {
                entityItem.m_142687_(Entity.RemovalReason.KILLED);
            }
            return;
        }
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        int i;
        this.addRune(components, 2, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, -2, 0, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 0, 2, EnumRuneType.FIRE);
        this.addRune(components, 0, 0, -2, EnumRuneType.FIRE);
        this.addRune(components, 3, 0, 1, EnumRuneType.AIR);
        this.addRune(components, 3, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -3, 0, 1, EnumRuneType.AIR);
        this.addRune(components, -3, 0, -1, EnumRuneType.AIR);
        this.addRune(components, 1, 0, 3, EnumRuneType.AIR);
        this.addRune(components, -1, 0, 3, EnumRuneType.AIR);
        this.addRune(components, 1, 0, -3, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -3, EnumRuneType.AIR);
        this.addRune(components, 4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, 2, EnumRuneType.AIR);
        this.addRune(components, -4, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 4, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, -2, 0, -4, EnumRuneType.AIR);
        this.addRune(components, 5, 0, 3, EnumRuneType.DUSK);
        this.addRune(components, 5, 0, -3, EnumRuneType.DUSK);
        this.addRune(components, -5, 0, 3, EnumRuneType.DUSK);
        this.addRune(components, -5, 0, -3, EnumRuneType.DUSK);
        this.addRune(components, 3, 0, 5, EnumRuneType.DUSK);
        this.addRune(components, -3, 0, 5, EnumRuneType.DUSK);
        this.addRune(components, 3, 0, -5, EnumRuneType.DUSK);
        this.addRune(components, -3, 0, -5, EnumRuneType.DUSK);
        this.addRune(components, -4, 0, -4, EnumRuneType.DUSK);
        this.addRune(components, -4, 0, 4, EnumRuneType.DUSK);
        this.addRune(components, 4, 0, 4, EnumRuneType.DUSK);
        this.addRune(components, 4, 0, -4, EnumRuneType.DUSK);
        for (i = 4; i <= 6; ++i) {
            this.addRune(components, i, 0, 0, EnumRuneType.EARTH);
            this.addRune(components, -i, 0, 0, EnumRuneType.EARTH);
            this.addRune(components, 0, 0, i, EnumRuneType.EARTH);
            this.addRune(components, 0, 0, -i, EnumRuneType.EARTH);
        }
        this.addRune(components, 8, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, -8, 0, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, 8, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, -8, EnumRuneType.EARTH);
        this.addRune(components, 8, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, -8, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, 8, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, -8, EnumRuneType.EARTH);
        this.addRune(components, 7, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, -7, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, 7, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, -7, EnumRuneType.EARTH);
        this.addRune(components, 7, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, -7, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, 7, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, -7, EnumRuneType.FIRE);
        this.addRune(components, 6, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, -6, 2, 0, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, 6, EnumRuneType.FIRE);
        this.addRune(components, 0, 2, -6, EnumRuneType.FIRE);
        this.addRune(components, 6, 3, 0, EnumRuneType.WATER);
        this.addRune(components, -6, 3, 0, EnumRuneType.WATER);
        this.addRune(components, 0, 3, 6, EnumRuneType.WATER);
        this.addRune(components, 0, 3, -6, EnumRuneType.WATER);
        this.addRune(components, 5, 3, 0, EnumRuneType.WATER);
        this.addRune(components, -5, 3, 0, EnumRuneType.WATER);
        this.addRune(components, 0, 3, 5, EnumRuneType.WATER);
        this.addRune(components, 0, 3, -5, EnumRuneType.WATER);
        this.addRune(components, 5, 4, 0, EnumRuneType.AIR);
        this.addRune(components, -5, 4, 0, EnumRuneType.AIR);
        this.addRune(components, 0, 4, 5, EnumRuneType.AIR);
        this.addRune(components, 0, 4, -5, EnumRuneType.AIR);
        for (i = -1; i <= 1; ++i) {
            this.addRune(components, i, 4, 4, EnumRuneType.AIR);
            this.addRune(components, i, 4, -4, EnumRuneType.AIR);
            this.addRune(components, 4, 4, i, EnumRuneType.AIR);
            this.addRune(components, -4, 4, i, EnumRuneType.AIR);
        }
        this.addRune(components, 2, 4, 4, EnumRuneType.WATER);
        this.addRune(components, 4, 4, 2, EnumRuneType.WATER);
        this.addRune(components, 2, 4, -4, EnumRuneType.WATER);
        this.addRune(components, -4, 4, 2, EnumRuneType.WATER);
        this.addRune(components, -2, 4, 4, EnumRuneType.WATER);
        this.addRune(components, 4, 4, -2, EnumRuneType.WATER);
        this.addRune(components, -2, 4, -4, EnumRuneType.WATER);
        this.addRune(components, -4, 4, -2, EnumRuneType.WATER);
        this.addRune(components, 2, 4, 3, EnumRuneType.FIRE);
        this.addRune(components, 3, 4, 2, EnumRuneType.FIRE);
        this.addRune(components, 3, 4, 3, EnumRuneType.FIRE);
        this.addRune(components, -2, 4, 3, EnumRuneType.FIRE);
        this.addRune(components, 3, 4, -2, EnumRuneType.FIRE);
        this.addRune(components, 3, 4, -3, EnumRuneType.FIRE);
        this.addRune(components, 2, 4, -3, EnumRuneType.FIRE);
        this.addRune(components, -3, 4, 2, EnumRuneType.FIRE);
        this.addRune(components, -3, 4, 3, EnumRuneType.FIRE);
        this.addRune(components, -2, 4, -3, EnumRuneType.FIRE);
        this.addRune(components, -3, 4, -2, EnumRuneType.FIRE);
        this.addRune(components, -3, 4, -3, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualMeteor();
    }
}

