/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;
import wayoftime.bloodmagic.common.item.ItemLivingTomeScrap;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeLivingDowngrade;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="downgrade")
public class RitualLivingDowngrade
extends Ritual {
    public static final String DOWNGRADE_RANGE = "containmentRange";

    public RitualLivingDowngrade() {
        super("ritualDowngrade", 0, 10000, "ritual.bloodmagic.downgradeRitual");
        this.addBlockRange(DOWNGRADE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 0, -1), 3));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        int requiredPoints;
        Object downgrade;
        Level world = masterRitualStone.getWorldObj();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        Direction direction = masterRitualStone.getDirection();
        Player selectedPlayer = null;
        AreaDescriptor downgradeRange = masterRitualStone.getBlockRange(DOWNGRADE_RANGE);
        for (Player player : world.m_45976_(Player.class, downgradeRange.getAABB(masterRitualStone.getMasterBlockPos()))) {
            if (player.m_6047_() || !LivingUtil.hasFullSet(player)) continue;
            selectedPlayer = player;
            break;
        }
        if (selectedPlayer == null) {
            return;
        }
        LivingStats playerStats = LivingStats.fromPlayer(selectedPlayer, true);
        BlockPos chestOffsetPos = new BlockPos(0, 1, 0);
        BlockPos chestPos = masterPos.m_121955_((Vec3i)(chestOffsetPos = chestOffsetPos.m_5484_(direction, 2)));
        BlockEntity tile = world.m_7702_(chestPos);
        if (tile == null) {
            selectedPlayer.m_5661_((Component)Component.m_237110_((String)"chat.bloodmagic.ritualLivingDowngrade.missingInventory", (Object[])new Object[]{chestPos.m_123341_(), chestPos.m_123342_(), chestPos.m_123343_()}), true);
            return;
        }
        HashMap<LivingUpgrade, Integer> downgradeMap = new HashMap<LivingUpgrade, Integer>();
        int availablePoints = 0;
        Direction accessDir = Direction.DOWN;
        HashMap priorityMap = new HashMap();
        HashMap<LivingUpgrade, ItemStack> downgradeItemStacksMap = new HashMap<LivingUpgrade, ItemStack>();
        LazyOptional capability = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, accessDir);
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                int priority;
                ItemStack invStack = handler.getStackInSlot(i);
                availablePoints += this.getAvailablePointsFromStack(invStack);
                LivingUpgrade downgrade2 = this.getDowngradeFromStack(world, invStack);
                if (downgrade2 != null && downgrade2 != LivingUpgrade.DUMMY) {
                    int wantedLevel = this.getLevelFromStack(invStack);
                    downgradeMap.put(downgrade2, downgradeMap.getOrDefault(downgrade2, 0) + wantedLevel);
                    downgradeItemStacksMap.put(downgrade2, invStack);
                }
                if ((priority = this.getPriorityFromStack(invStack)) < 0) continue;
                if (priorityMap.containsKey(priority)) {
                    ((List)priorityMap.get(priority)).add(i);
                    continue;
                }
                ArrayList<Integer> priorityList = new ArrayList<Integer>();
                priorityList.add(i);
                priorityMap.put(priority, priorityList);
            }
        } else if (tile instanceof Container) {
            for (int i = 0; i < ((Container)tile).m_6643_(); ++i) {
                int priority;
                ItemStack invStack = ((Container)tile).m_8020_(i);
                availablePoints += this.getAvailablePointsFromStack(invStack);
                LivingUpgrade downgrade3 = this.getDowngradeFromStack(world, invStack);
                if (downgrade3 != null && downgrade3 != LivingUpgrade.DUMMY) {
                    int wantedLevel = this.getLevelFromStack(invStack);
                    downgradeMap.put(downgrade3, downgradeMap.getOrDefault(downgrade3, 0) + wantedLevel);
                    downgradeItemStacksMap.put(downgrade3, invStack);
                }
                if ((priority = this.getPriorityFromStack(invStack)) < 0) continue;
                if (priorityMap.containsKey(priority)) {
                    ((List)priorityMap.get(priority)).add(i);
                    continue;
                }
                ArrayList<Integer> priorityList = new ArrayList<Integer>();
                priorityList.add(i);
                priorityMap.put(priority, priorityList);
            }
        }
        if (downgradeMap.isEmpty()) {
            return;
        }
        HashMap<Object, Integer> pointDifferentialMap = new HashMap<Object, Integer>();
        int totalDifferentialPoints = 0;
        Object lastSkippedDowngrade = null;
        for (Map.Entry entry : downgradeMap.entrySet()) {
            int totalRequiredPoints;
            int upgradeRequiredPoints;
            int wantedLevel;
            downgrade = (LivingUpgrade)entry.getKey();
            int playerDowngradeLevel = playerStats.getLevel(((LivingUpgrade)downgrade).getKey());
            if (playerDowngradeLevel >= (wantedLevel = Math.min((Integer)entry.getValue(), ((LivingUpgrade)downgrade).getLevel(Integer.MAX_VALUE)))) {
                lastSkippedDowngrade = downgrade;
                continue;
            }
            if (!LivingUtil.canTrain(selectedPlayer, (LivingUpgrade)downgrade, playerDowngradeLevel, wantedLevel)) {
                selectedPlayer.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.ritualLivingDowngrade.trainingBraceletBlock"), true);
                return;
            }
            int playerInitialPoints = 0;
            if (playerDowngradeLevel > 0) {
                playerInitialPoints = playerStats.getUpgrades().getOrDefault(downgrade, 0.0).intValue();
            }
            if ((upgradeRequiredPoints = (totalRequiredPoints = Math.abs(((LivingUpgrade)downgrade).getLevelCost(wantedLevel))) - playerInitialPoints) <= 0) continue;
            pointDifferentialMap.put(downgrade, upgradeRequiredPoints);
            totalDifferentialPoints += upgradeRequiredPoints;
        }
        if (availablePoints < totalDifferentialPoints) {
            selectedPlayer.m_5661_((Component)Component.m_237115_((String)"chat.bloodmagic.ritualLivingDowngrade.notEnoughPoints"), true);
            return;
        }
        if (priorityMap.isEmpty() || pointDifferentialMap.isEmpty()) {
            if (lastSkippedDowngrade != null) {
                String itemName = ((ItemStack)downgradeItemStacksMap.get(lastSkippedDowngrade)).m_41720_().m_7968_().m_41611_().getString();
                int lastCharIndex = itemName.length() - 1;
                if (itemName.charAt(0) == '[' && itemName.charAt(lastCharIndex) == ']') {
                    itemName = itemName.substring(1, lastCharIndex);
                }
                selectedPlayer.m_5661_((Component)Component.m_237110_((String)"chat.bloodmagic.ritualLivingDowngrade.notEnoughKeyItems", (Object[])new Object[]{itemName}), true);
            }
            return;
        }
        ArrayList slotOrderList = new ArrayList();
        ArrayList priorityList = new ArrayList(priorityMap.keySet());
        Collections.sort(priorityList);
        downgrade = priorityList.iterator();
        while (downgrade.hasNext()) {
            int priority = (Integer)downgrade.next();
            slotOrderList.addAll((Collection)priorityMap.get(priority));
        }
        int initialRequiredPoints = requiredPoints = totalDifferentialPoints;
        ArrayList<ItemStack> excessStackList = new ArrayList<ItemStack>();
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            Iterator totalRequiredPoints = slotOrderList.iterator();
            while (totalRequiredPoints.hasNext()) {
                int i = (Integer)totalRequiredPoints.next();
                ItemStack invStack = handler.getStackInSlot(i);
                if (invStack.m_41619_() || !(invStack.m_41720_() instanceof ILivingUpgradePointsProvider)) continue;
                ItemStack simStack = handler.extractItem(i, invStack.m_41613_(), true);
                int containedPoints = ((ILivingUpgradePointsProvider)simStack.m_41720_()).getAvailableUpgradePoints(simStack, requiredPoints);
                int drainPoints = Math.min(containedPoints, requiredPoints);
                int remainingPointsInItem = ((ILivingUpgradePointsProvider)simStack.m_41720_()).getExcessUpgradePoints(simStack, drainPoints);
                ItemStack newItemStack = ((ILivingUpgradePointsProvider)simStack.m_41720_()).getResultingStack(simStack, drainPoints);
                if (!newItemStack.m_41619_() && !handler.isItemValid(i, newItemStack)) continue;
                int totalPoints = ((ILivingUpgradePointsProvider)simStack.m_41720_()).getTotalUpgradePoints(simStack);
                int totalDrainedPoints = totalPoints - remainingPointsInItem;
                requiredPoints -= totalDrainedPoints;
                handler.extractItem(i, simStack.m_41613_(), false);
                ItemStack remainingStack = handler.insertItem(i, newItemStack, false);
                if (!remainingStack.m_41619_()) {
                    excessStackList.add(remainingStack);
                }
                if (requiredPoints > 0) continue;
                break;
            }
        } else if (tile instanceof Container) {
            Iterator handler = slotOrderList.iterator();
            while (handler.hasNext()) {
                int i = (Integer)handler.next();
                ItemStack invStack = ((Container)tile).m_8020_(i);
                if (invStack.m_41619_() || !(invStack.m_41720_() instanceof ILivingUpgradePointsProvider)) continue;
                int drainPoints = Math.min(((ILivingUpgradePointsProvider)invStack.m_41720_()).getAvailableUpgradePoints(invStack, requiredPoints), requiredPoints);
                int remainingPointsInItem = ((ILivingUpgradePointsProvider)invStack.m_41720_()).getExcessUpgradePoints(invStack, drainPoints);
                ItemStack newItemStack = ((ILivingUpgradePointsProvider)invStack.m_41720_()).getResultingStack(invStack, drainPoints);
                ((Container)tile).m_6836_(i, newItemStack);
                if ((requiredPoints -= drainPoints - remainingPointsInItem) > 0) continue;
                break;
            }
        }
        if (requiredPoints < 0) {
            ItemStack scrapStack = new ItemStack((ItemLike)BloodMagicItems.UPGRADE_SCRAPS.get());
            ((ItemLivingTomeScrap)BloodMagicItems.UPGRADE_SCRAPS.get()).setTotalUpgradePoints(scrapStack, Math.abs(requiredPoints));
            excessStackList.add(scrapStack);
        }
        if (requiredPoints <= 0) {
            for (Map.Entry entry : pointDifferentialMap.entrySet()) {
                LivingUtil.applyExperienceToUpgradeCap(selectedPlayer, (LivingUpgrade)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            masterRitualStone.setActive(false);
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningboltentity.m_6034_((double)masterPos.m_123341_() + 0.5, (double)masterPos.m_123342_(), (double)masterPos.m_123343_() + 0.5);
            world.m_7967_((Entity)lightningboltentity);
        } else if (requiredPoints < initialRequiredPoints) {
            ItemStack scrapStack = new ItemStack((ItemLike)BloodMagicItems.UPGRADE_SCRAPS.get());
            ((ItemLivingTomeScrap)BloodMagicItems.UPGRADE_SCRAPS.get()).setTotalUpgradePoints(scrapStack, Math.abs(initialRequiredPoints - requiredPoints));
            excessStackList.add(scrapStack);
        }
        for (ItemStack item : excessStackList) {
            ItemStack copyStack = item.m_41777_();
            if (tile == null) {
                Utils.spawnStackAtBlock(world, chestPos, Direction.UP, copyStack);
                continue;
            }
            copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
            if (copyStack.m_41619_()) continue;
            Utils.spawnStackAtBlock(world, chestPos, Direction.UP, copyStack);
        }
    }

    public int getAvailablePointsFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() instanceof ILivingUpgradePointsProvider) {
            return ((ILivingUpgradePointsProvider)stack.m_41720_()).getTotalUpgradePoints(stack);
        }
        return 0;
    }

    public int getPriorityFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return -1;
        }
        if (stack.m_41720_() instanceof ILivingUpgradePointsProvider) {
            return ((ILivingUpgradePointsProvider)stack.m_41720_()).getPriority(stack);
        }
        return 0;
    }

    public int getLevelFromStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (!(stack.m_41720_() instanceof ILivingUpgradePointsProvider)) {
            return stack.m_41613_();
        }
        return 0;
    }

    public LivingUpgrade getDowngradeFromStack(Level world, ItemStack focusStack) {
        RecipeLivingDowngrade downgradeRecipe;
        if (focusStack.m_41619_()) {
            return LivingUpgrade.DUMMY;
        }
        if (!(focusStack.m_41720_() instanceof ILivingUpgradePointsProvider) && (downgradeRecipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getLivingDowngrade(world, focusStack)) != null) {
            return LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(downgradeRecipe.getLivingArmourResource(), LivingUpgrade.DUMMY);
        }
        return LivingUpgrade.DUMMY;
    }

    public ItemStack getStackFromItemFrame(Level world, BlockPos masterPos, Direction direction) {
        BlockPos offsetPos = new BlockPos(0, 3, 0);
        offsetPos = offsetPos.m_5484_(direction, 2);
        AABB bb = new AABB(masterPos.m_121955_((Vec3i)offsetPos));
        List frames = world.m_45976_(ItemFrame.class, bb);
        for (ItemFrame frame : frames) {
            if (frame.m_31822_().m_41619_()) continue;
            return frame.m_31822_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -1, EnumRuneType.AIR);
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 0, 1, -3, EnumRuneType.DUSK);
        this.addRune(components, 0, 2, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 3, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 1, -4, EnumRuneType.FIRE);
        for (int i = 1; i <= 3; ++i) {
            this.addRune(components, 0, 0, i, EnumRuneType.AIR);
        }
        for (int sgn = -1; sgn <= 1; sgn += 2) {
            this.addRune(components, sgn, 0, 4, EnumRuneType.AIR);
            this.addRune(components, sgn * 2, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 3, EnumRuneType.AIR);
            this.addRune(components, sgn, 0, 0, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, 1, EnumRuneType.EARTH);
            this.addRune(components, sgn * 2, 0, -1, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -3, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn, 1, -1, EnumRuneType.AIR);
            this.addRune(components, sgn, 1, -2, EnumRuneType.AIR);
            this.addRune(components, sgn, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn, 0, -3, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, -4, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 1, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 2, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 3, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 3, -4, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLivingDowngrade();
    }
}

