/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.registries.BloodMagicDamageTypes;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="geode")
public class RitualGeode
extends Ritual {
    public static final String ACCELERATION_RANGE = "acceleration";
    public static final String HARVEST_RANGE = "harvest";
    public static final String CHEST_RANGE = "chest";
    public static final String HARM_RANGE = "harm";
    public static final double MIN_DEFAULT = (Double)ConfigManager.COMMON.min_raw_will.get();
    public static final double MIN_DESTRUCTIVE = (Double)ConfigManager.COMMON.min_destructive_will.get();
    public static final double MIN_CORROSIVE = (Double)ConfigManager.COMMON.min_corrosive_will.get();
    public static final double MIN_STEADFAST = (Double)ConfigManager.COMMON.min_steadfast_will.get();
    public static final double MIN_VENGEFUL = (Double)ConfigManager.COMMON.min_vengeful_will.get();
    public static final double WILL_PER_SILK = (Double)ConfigManager.COMMON.silk_touch_cost.get();
    public static final double WILL_PER_FORTUNE = (Double)ConfigManager.COMMON.fortune_cost.get();
    public static final double WILL_PER_GROWTH = (Double)ConfigManager.COMMON.growth_cost.get();
    public static final double WILL_PER_STORE = (Double)ConfigManager.COMMON.store_cost.get();
    public static final double WILL_PER_HARM = (Double)ConfigManager.COMMON.harm_cost.get();
    public static final int ACTIVATION_COST = (Integer)ConfigManager.COMMON.activation_cost.get();
    public static final int REFRESH_COST = (Integer)ConfigManager.COMMON.refresh_cost.get();
    public static final int HURT_DAMAGE = (Integer)ConfigManager.COMMON.hurt_damage.get();
    public static final int MAX_BLOCKS = (Integer)ConfigManager.COMMON.max_budding_blocks.get();
    public static final int MAX_HARM = (Integer)ConfigManager.COMMON.max_mobs_harmed.get();
    public static final ItemStack mockPick = new ItemStack((ItemLike)Items.f_42395_);
    public static final ItemStack fortunePick = new ItemStack((ItemLike)Items.f_42395_);
    public static final ItemStack silkPick = new ItemStack((ItemLike)Items.f_42395_);

    public RitualGeode() {
        super("ritualGeode", 0, ACTIVATION_COST, "ritual.bloodmagic.geode");
        this.addBlockRange(HARVEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 2, -1), 3, 3, 3));
        this.addBlockRange(ACCELERATION_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 3, 0), 1));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(HARM_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, -3, -1), 3, 3, 3));
        this.setMaximumVolumeAndDistanceOfRange(HARVEST_RANGE, 9 * (2 + MAX_BLOCKS), 15, 15);
        this.setMaximumVolumeAndDistanceOfRange(ACCELERATION_RANGE, MAX_BLOCKS, 15, 15);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 15, 15);
        this.setMaximumVolumeAndDistanceOfRange(HARM_RANGE, 75, 15, 15);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        if (world.f_46443_) {
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        BlockPos chestPos = masterRitualStone.getBlockRange(CHEST_RANGE).getContainedPositions(pos).get(0);
        BlockEntity inv = world.m_7702_(chestPos);
        boolean hasInv = inv != null && Utils.getNumberOfFreeSlots(inv, Direction.DOWN) >= 1;
        boolean doHarm = vengefulWill > MIN_VENGEFUL;
        boolean doAccel = corrosiveWill > MIN_CORROSIVE;
        boolean doStore = rawWill > MIN_DEFAULT && hasInv;
        boolean doFortune = false;
        boolean doSilk = false;
        ItemStack toolStack = mockPick;
        if (destructiveWill > MIN_DESTRUCTIVE) {
            toolStack = fortunePick;
            doFortune = true;
        }
        if (steadfastWill > MIN_STEADFAST) {
            toolStack = silkPick;
            doSilk = true;
        }
        double fortuneWill = destructiveWill;
        double silkWill = steadfastWill;
        double storeWill = rawWill;
        ArrayList drops = new ArrayList();
        for (BlockPos harvestPos : masterRitualStone.getBlockRange(HARVEST_RANGE).getContainedPositions(pos)) {
            BlockState state = world.m_8055_(harvestPos);
            if (!state.m_204336_(BloodMagicTags.Blocks.GEODE_HARVESTABLE) || doFortune && fortuneWill < WILL_PER_FORTUNE || doSilk && silkWill < WILL_PER_SILK) continue;
            LootParams.Builder lootBuilder = new LootParams.Builder((ServerLevel)world);
            Vec3 blockCenter = new Vec3((double)harvestPos.m_123341_() + 0.5, (double)harvestPos.m_123342_() + 0.5, (double)harvestPos.m_123343_() + 0.5);
            List blockDrops = state.m_287290_(lootBuilder.m_287286_(LootContextParams.f_81460_, (Object)blockCenter).m_287286_(LootContextParams.f_81463_, (Object)toolStack));
            drops.addAll(blockDrops);
            world.m_46961_(harvestPos, false);
            if (doFortune) {
                fortuneWill -= WILL_PER_FORTUNE;
            }
            if (doSilk) {
                silkWill -= WILL_PER_SILK;
            }
            for (ItemStack dropStack : drops) {
                if (doStore && storeWill >= WILL_PER_STORE * (double)blockDrops.size()) {
                    int size = dropStack.m_41613_();
                    dropStack = Utils.insertStackIntoTile(dropStack, inv, Direction.DOWN);
                    storeWill -= (double)(size - dropStack.m_41613_());
                }
                if (dropStack.m_41619_()) continue;
                Utils.spawnStackAtBlock(world, harvestPos, Direction.UP, dropStack);
            }
        }
        double harmWill = vengefulWill;
        double harmTicks = 0.0;
        for (LivingEntity mob : world.m_45976_(LivingEntity.class, masterRitualStone.getBlockRange(HARM_RANGE).getAABB(pos))) {
            if (!doHarm || !(harmWill >= WILL_PER_HARM)) continue;
            if (mob.m_6469_(world.m_269111_().m_269079_(BloodMagicDamageTypes.SACRIFICE), (float)HURT_DAMAGE)) {
                harmTicks += 1.0;
                harmWill -= WILL_PER_HARM;
            }
            if (!(harmTicks >= (double)MAX_HARM)) continue;
            break;
        }
        double accelWill = corrosiveWill;
        for (BlockPos accelPos : masterRitualStone.getBlockRange(ACCELERATION_RANGE).getContainedPositions(pos)) {
            BlockState state = world.m_8055_(accelPos);
            if (!state.m_204336_(BloodMagicTags.Blocks.GEODE_ACCELERATABLE)) continue;
            int i = 0;
            while ((double)i < harmTicks) {
                state.m_222972_((ServerLevel)world, accelPos, world.m_213780_());
                ++i;
            }
            if (!doAccel || !(accelWill >= WILL_PER_GROWTH)) continue;
            state.m_222972_((ServerLevel)world, accelPos, world.m_213780_());
            state.m_222972_((ServerLevel)world, accelPos, world.m_213780_());
            accelWill -= WILL_PER_GROWTH;
        }
        if (doStore) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawWill - storeWill, true);
        }
        if (doFortune) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveWill - fortuneWill, true);
        }
        if (doSilk) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastWill - silkWill, true);
        }
        if (doAccel) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveWill - accelWill, true);
        }
        if (doHarm) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulWill - harmWill, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
    }

    @Override
    public int getRefreshCost() {
        return REFRESH_COST;
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)"%s.info".formatted(this.getTranslationKey())), Component.m_237115_((String)(this.getTranslationKey() + ".default.info")), Component.m_237115_((String)(this.getTranslationKey() + ".corrosive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".steadfast.info")), Component.m_237115_((String)(this.getTranslationKey() + ".destructive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".vengeful.info"))};
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualGeode();
    }

    static {
        EnchantmentHelper.m_44865_(Map.of(Enchantments.f_44987_, 3), (ItemStack)fortunePick);
        EnchantmentHelper.m_44865_(Map.of(Enchantments.f_44985_, 1), (ItemStack)silkPick);
    }
}

