/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.helper;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import wayoftime.bloodmagic.recipe.helper.InputIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public abstract class FluidStackIngredient
implements InputIngredient<FluidStack> {
    public static FluidStackIngredient from(@Nonnull Fluid instance, int amount) {
        return FluidStackIngredient.from(new FluidStack(instance, amount));
    }

    public static FluidStackIngredient from(@Nonnull FluidStack instance) {
        return new Single(instance);
    }

    public static FluidStackIngredient from(@Nonnull TagKey<Fluid> fluidTag, int minAmount) {
        return new Tagged(fluidTag, minAmount);
    }

    public static FluidStackIngredient read(FriendlyByteBuf buffer) {
        IngredientType type = (IngredientType)buffer.m_130066_(IngredientType.class);
        if (type == IngredientType.SINGLE) {
            return Single.read(buffer);
        }
        if (type == IngredientType.TAGGED) {
            return Tagged.read(buffer);
        }
        return Multi.read(buffer);
    }

    public static FluidStackIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined");
            }
            if (size > 1) {
                FluidStackIngredient[] ingredients = new FluidStackIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = FluidStackIngredient.deserialize(jsonArray.get(i));
                }
                return FluidStackIngredient.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("fluid") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an fluid, not both");
        }
        if (jsonObject.has("fluid")) {
            return FluidStackIngredient.from(SerializerHelper.deserializeFluid(jsonObject));
        }
        if (jsonObject.has("tag")) {
            if (!jsonObject.has("amount")) {
                throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
            }
            JsonElement count = jsonObject.get("amount");
            if (!GsonHelper.m_13872_((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
            }
            int amount = count.getAsJsonPrimitive().getAsInt();
            if (amount < 1) {
                throw new JsonSyntaxException("Expected amount to be greater than zero.");
            }
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
            ITagManager tagManager = ForgeRegistries.FLUIDS.tags();
            TagKey tag = tagManager.createTagKey(resourceLocation);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown fluid tag '" + String.valueOf(resourceLocation) + "'");
            }
            return FluidStackIngredient.from((TagKey<Fluid>)tag, amount);
        }
        throw new JsonSyntaxException("Expected to receive a resource location representing either a tag or a fluid.");
    }

    public static FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        if (ingredients.length != 0 && ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<FluidStackIngredient> cleanedIngredients = new ArrayList<FluidStackIngredient>();
        for (FluidStackIngredient ingredient : ingredients) {
            if (ingredient instanceof Multi) {
                cleanedIngredients.addAll(Arrays.asList(((Multi)ingredient).ingredients));
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new Multi(cleanedIngredients.toArray(new FluidStackIngredient[0]));
    }

    public static class Single
    extends FluidStackIngredient {
        @Nonnull
        private final FluidStack fluidInstance;

        public Single(@Nonnull FluidStack fluidInstance) {
            this.fluidInstance = Objects.requireNonNull(fluidInstance);
        }

        @Override
        public boolean test(@Nonnull FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.fluidInstance.getAmount();
        }

        @Override
        public boolean testType(@Nonnull FluidStack fluidStack) {
            return Objects.requireNonNull(fluidStack).isFluidEqual(this.fluidInstance);
        }

        @Override
        @Nonnull
        public FluidStack getMatchingInstance(@Nonnull FluidStack fluidStack) {
            return this.test(fluidStack) ? this.fluidInstance : FluidStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<FluidStack> getRepresentations() {
            return Collections.singletonList(this.fluidInstance);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.SINGLE);
            this.fluidInstance.writeToPacket(buffer);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.fluidInstance.getAmount());
            json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluidInstance.getFluid()).toString());
            if (this.fluidInstance.hasTag()) {
                json.addProperty("nbt", this.fluidInstance.getTag().toString());
            }
            return json;
        }

        public static Single read(FriendlyByteBuf buffer) {
            return new Single(FluidStack.readFromPacket((FriendlyByteBuf)buffer));
        }
    }

    public static class Tagged
    extends FluidStackIngredient {
        private final ITag<Fluid> tag;
        private final int amount;

        private Tagged(TagKey<Fluid> tag, int amount) {
            this((ITag<Fluid>)ForgeRegistries.FLUIDS.tags().getTag(tag), amount);
        }

        private Tagged(ITag<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public boolean test(FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(FluidStack fluidStack) {
            return this.tag.contains((Object)Objects.requireNonNull(fluidStack).getFluid());
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack fluidStack) {
            if (this.test(fluidStack)) {
                return new FluidStack(fluidStack, this.amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public List<@NonNull FluidStack> getRepresentations() {
            ArrayList<@NonNull FluidStack> representations = new ArrayList<FluidStack>();
            for (Fluid fluid : this.tag) {
                representations.add(new FluidStack(fluid, this.amount));
            }
            return representations;
        }

        public Iterable<Fluid> getRawInput() {
            return this.tag;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.TAGGED);
            buffer.m_130085_(this.tag.getKey().f_203868_());
            buffer.m_130130_(this.amount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("tag", this.tag.getKey().f_203868_().toString());
            return json;
        }
    }

    private static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    public static class Multi
    extends FluidStackIngredient {
        private final FluidStackIngredient[] ingredients;

        protected Multi(FluidStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(@Nonnull FluidStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@Nonnull FluidStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        @Nonnull
        public FluidStack getMatchingInstance(@Nonnull FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                FluidStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return FluidStack.EMPTY;
        }

        @Override
        @Nonnull
        public List<FluidStack> getRepresentations() {
            ArrayList<FluidStack> representations = new ArrayList<FluidStack>();
            for (FluidStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.MULTI);
            buffer.m_130130_(this.ingredients.length);
            for (FluidStackIngredient ingredient : this.ingredients) {
                ingredient.write(buffer);
            }
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (FluidStackIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        public static FluidStackIngredient read(FriendlyByteBuf buffer) {
            FluidStackIngredient[] ingredients = new FluidStackIngredient[buffer.m_130242_()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = FluidStackIngredient.read(buffer);
            }
            return Multi.createMulti(ingredients);
        }
    }
}

