/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.alchemytable;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;
import wayoftime.bloodmagic.util.ChatUtil;

public class PotionRecipeCategory
implements IRecipeCategory<RecipePotionFlaskBase> {
    public static final RecipeType<RecipePotionFlaskBase> RECIPE_TYPE = RecipeType.create((String)"bloodmagic", (String)"potion", RecipePotionFlaskBase.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public PotionRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/alchemytable.png"), 0, 0, 118, 40);
    }

    public List<Component> getTooltipStrings(RecipePotionFlaskBase recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 58.0 && mouseX <= 78.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(Component.m_237110_((String)"tooltip.bloodmagic.tier", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumTier())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.lpDrained", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSyphon())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.ticksRequired", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getTicks())}));
        }
        return tooltip;
    }

    public void draw(RecipePotionFlaskBase recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(64.0f, 23.0f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.bloodmagic.recipe.lp"), 0, 0, 0x8B8B8B, false);
        poseStack.m_252880_(-8.0f, 15.0f, 0.0f);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.bloodmagic.recipe.info"), 0, 0, 0x8B8B8B, false);
        poseStack.m_85849_();
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.bloodmagic.recipe.potionflask");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull RecipePotionFlaskBase recipe, @Nonnull IFocusGroup focuses) {
        List<ItemStack> validOrbs = OrbRegistry.getOrbsDownToTier(recipe.getMinimumTier());
        ItemStack[] validOrbStacks = new ItemStack[validOrbs.size()];
        for (int i = 0; i < validOrbStacks.length; ++i) {
            validOrbStacks[i] = validOrbs.get(i);
        }
        Item[] flaskItems = new Item[]{(Item)BloodMagicItems.ALCHEMY_FLASK.get(), (Item)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get(), (Item)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get()};
        ItemStack[] flaskStacks = new ItemStack[flaskItems.length];
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 61, 1).addIngredients(Ingredient.m_43927_((ItemStack[])validOrbStacks))).setSlotName("orbs");
        ItemStack flaskStack = recipe.getExamplePotionFlask();
        for (int i = 0; i < flaskItems.length; ++i) {
            Item inputFlask = flaskItems[i];
            ItemStack copyFlaskStack = new ItemStack((ItemLike)inputFlask);
            copyFlaskStack.m_41751_(flaskStack.m_41783_());
            flaskStacks[i] = copyFlaskStack;
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(Ingredient.m_43927_((ItemStack[])flaskStacks))).setSlotName("flask");
        List<Ingredient> inputList = recipe.getInput();
        for (int index = 0; index < inputList.size(); ++index) {
            int x = (index + 1) % 3;
            int y = (index + 1) / 3;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1).addIngredients(inputList.get(index))).setSlotName("input");
        }
        List<EffectHolder> holderList = ((ItemAlchemyFlask)flaskStack.m_41720_()).getEffectHoldersOfFlask(flaskStack);
        ItemStack outputStack = recipe.getOutput(flaskStack, holderList);
        ((ItemAlchemyFlask)flaskStack.m_41720_()).resyncEffectInstances(outputStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 14).addItemStack(outputStack)).setSlotName("output");
    }

    public RecipeType<RecipePotionFlaskBase> getRecipeType() {
        return RECIPE_TYPE;
    }
}

