/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

public class CuriosCompat {
    public void registerInventory() {
        BloodMagicAPI.INSTANCE.registerInventoryProvider("curiosInventory", player -> this.getCuriosInventory((Player)player));
        BloodMagicAPI.INSTANCE.registerActiveInventoryProvider("curiosInventory");
    }

    public NonNullList<ItemStack> getCuriosInventory(Player player) {
        Optional curioInv = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (curioInv.isEmpty()) {
            return NonNullList.m_122779_();
        }
        IItemHandlerModifiable itemHandler = ((ICuriosItemHandler)curioInv.get()).getEquippedCurios();
        NonNullList inventory = NonNullList.m_122779_();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            inventory.add((Object)itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public int recalculateCuriosSlots(Player player) {
        ICurioStacksHandler livingArmourSockets = (ICurioStacksHandler)((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).resolve().get()).getCurios().get("living_armour_socket");
        if (LivingUtil.hasFullSet(player)) {
            LivingStats stats = LivingStats.fromPlayer(player);
            int curiosLevel = stats != null ? stats.getLevel(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_CURIOS_SOCKET.get()).getKey()) : 0;
            livingArmourSockets.removeModifier(player.m_20148_());
            if (curiosLevel != 0) {
                livingArmourSockets.addTransientModifier(new AttributeModifier(player.m_20148_(), "legacy", Double.valueOf(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_CURIOS_SOCKET.get()).getBonusValue("slots", curiosLevel).intValue()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            return curiosLevel;
        }
        livingArmourSockets.removeModifier(player.m_20148_());
        return 0;
    }
}

