/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockSpectral;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.type.SpectralBlockType;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.base.TileBase;

public class TileSpectral
extends TileBase {
    public BlockState storedBlock;

    public TileSpectral(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileSpectral(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.SPECTRAL_TYPE.get(), pos, state);
    }

    public static void createOrRefreshSpectralBlock(Level world, BlockPos pos) {
        if (world.m_46859_(pos)) {
            return;
        }
        BlockState potentialFluidBlockState = world.m_8055_(pos);
        if (TileSpectral.isFluidBlock(potentialFluidBlockState.m_60734_())) {
            world.m_7731_(pos, ((Block)BloodMagicBlocks.SPECTRAL.get()).m_49966_(), 3);
            BlockEntity spectralTile = world.m_7702_(pos);
            if (spectralTile instanceof TileSpectral) {
                BloodMagic.LOGGER.info("was a spectral tile");
                ((TileSpectral)spectralTile).setContainedBlockInfo(potentialFluidBlockState);
                world.m_186460_(pos, spectralTile.m_58900_().m_60734_(), 100);
            } else {
                BloodMagic.LOGGER.info("it was not, in fact, a spectral tile");
            }
        } else if (potentialFluidBlockState.m_60734_() == BloodMagicBlocks.SPECTRAL.get() && potentialFluidBlockState.m_61143_(BlockSpectral.SPECTRAL_STATE) == SpectralBlockType.LEAKING) {
            world.m_7731_(pos, ((Block)BloodMagicBlocks.SPECTRAL.get()).m_49966_(), 0);
        }
    }

    public void revertToFluid() {
        this.f_58857_.m_7731_(this.f_58858_, this.storedBlock, 3);
    }

    public static boolean isFluidBlock(Block block) {
        return block instanceof LiquidBlock;
    }

    public void setContainedBlockInfo(BlockState state) {
        this.storedBlock = state;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.storedBlock = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("BlockState"));
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.storedBlock));
        return tag;
    }
}

