/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.common.container.tile.ContainerSoulForge;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;

public class TileSoulForge
extends TileInventory
implements MenuProvider,
IDemonWillConduit {
    public static final int ticksRequired = 100;
    public static final double worldWillTransferRate = 1.0;
    public static final int soulSlot = 4;
    public static final int outputSlot = 5;
    public int burnTime = 0;
    public boolean showWillFlag = false;
    public final ContainerData TileData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileSoulForge.this.burnTime;
                }
                case 1: {
                    return 100;
                }
                case 2: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void m_8050_(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TileSoulForge(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 6, "soulforge", pos, state);
    }

    public TileSoulForge(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.SOUL_FORGE_TYPE.get(), pos, state);
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.burnTime = tag.m_128451_("burnTime");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128405_("burnTime", this.burnTime);
        return tag;
    }

    public void tick() {
        if (!this.hasSoulGemOrSoul()) {
            this.showWillFlag = false;
            this.burnTime = 0;
            return;
        }
        if (!this.m_58904_().f_46443_) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double willInWorld = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, type);
                double filled = Math.min(willInWorld, 1.0);
                if (!(filled > 0.0)) continue;
                filled = this.fillDemonWill(type, filled, false);
                filled = WorldDemonWillHandler.drainWill(this.m_58904_(), this.f_58858_, type, filled, false);
                if (!(filled > 0.0)) continue;
                this.fillDemonWill(type, filled, true);
                WorldDemonWillHandler.drainWill(this.m_58904_(), this.f_58858_, type, filled, true);
            }
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            inputList.add(this.m_8020_(i));
        }
        RecipeTartaricForge recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForge(this.f_58857_, inputList);
        if (recipe != null) {
            double soulsInGem = 0.0;
            EnumDemonWillType typeInGem = EnumDemonWillType.DEFAULT;
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double quantityOfType = this.getWill(type);
                if (!(quantityOfType > soulsInGem)) continue;
                soulsInGem = quantityOfType;
                typeInGem = type;
            }
            if (soulsInGem >= recipe.getMinimumSouls()) {
                if (this.canCraft(recipe)) {
                    this.showWillFlag = false;
                    ++this.burnTime;
                    if (this.burnTime == 100) {
                        if (!this.m_58904_().f_46443_) {
                            double requiredSouls = recipe.getSoulDrain();
                            if (requiredSouls > 0.0) {
                                this.consumeSouls(typeInGem, requiredSouls);
                            }
                            this.craftItem(recipe);
                        }
                        this.burnTime = 0;
                    } else if (this.burnTime > 110) {
                        this.burnTime = 0;
                    }
                } else {
                    this.showWillFlag = false;
                    this.burnTime = 0;
                }
            } else {
                this.showWillFlag = true;
                this.burnTime = 0;
            }
        } else {
            this.showWillFlag = false;
            this.burnTime = 0;
        }
    }

    private boolean canCraft(RecipeTartaricForge recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack currentOutputStack = this.m_8020_(5);
        if (recipe.getOutput().m_41619_()) {
            return false;
        }
        if (currentOutputStack.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)currentOutputStack, (ItemStack)recipe.getOutput())) {
            return false;
        }
        int result = currentOutputStack.m_41613_() + recipe.getOutput().m_41613_();
        return result <= this.m_6893_() && result <= currentOutputStack.m_41741_();
    }

    public void craftItem(RecipeTartaricForge recipe) {
        if (this.canCraft(recipe)) {
            ItemStack currentOutputStack = this.m_8020_(5);
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            for (int i = 0; i < 4; ++i) {
                if (this.m_8020_(i).m_41619_()) continue;
                inputList.add(this.m_8020_(i).m_41777_());
            }
            BloodMagicCraftedEvent.SoulForge event = new BloodMagicCraftedEvent.SoulForge(recipe.getOutput().m_41777_(), inputList.toArray(new ItemStack[0]));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (currentOutputStack.m_41619_()) {
                this.m_6836_(5, event.getOutput());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentOutputStack, (ItemStack)event.getOutput())) {
                currentOutputStack.m_41769_(event.getOutput().m_41613_());
            }
            this.moveRemainingWillInConsumedInv();
            this.consumeInventory();
        }
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerSoulForge(this, this.TileData, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Hellfire Forge");
    }

    public boolean hasSoulGemOrSoul() {
        for (int i = 0; i <= 4; ++i) {
            ItemStack soulStack = this.m_8020_(i);
            if (soulStack.m_41619_() || !(soulStack.m_41720_() instanceof IDemonWill) && !(soulStack.m_41720_() instanceof IDemonWillGem)) continue;
            return true;
        }
        return false;
    }

    public double getProgressForGui() {
        return (double)this.burnTime / 100.0;
    }

    public double getWill(EnumDemonWillType type) {
        double will = 0.0;
        for (int i = 0; i <= 4; ++i) {
            Object soul;
            ItemStack soulStack = this.m_8020_(i);
            if (soulStack == null) continue;
            if (soulStack.m_41720_() instanceof IDemonWill && ((IDemonWill)soulStack.m_41720_()).getType(soulStack) == type) {
                soul = (IDemonWill)soulStack.m_41720_();
                will += soul.getWill(type, soulStack);
            }
            if (!(soulStack.m_41720_() instanceof IDemonWillGem)) continue;
            soul = (IDemonWillGem)soulStack.m_41720_();
            will += soul.getWill(type, soulStack);
        }
        return will;
    }

    public void moveRemainingWillInConsumedInv() {
        ItemStack outputStack = this.m_8020_(5);
        if (outputStack != null && outputStack.m_41720_() instanceof IDemonWillGem) {
            IDemonWillGem filledGem = (IDemonWillGem)outputStack.m_41720_();
            for (int i = 0; i < 4; ++i) {
                ItemStack soulStack = this.m_8020_(i);
                if (soulStack == null || !(soulStack.m_41720_() instanceof IDemonWillGem)) continue;
                IDemonWillGem syphonedGem = (IDemonWillGem)soulStack.m_41720_();
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    double willInGem = syphonedGem.getWill(type, soulStack);
                    if (!(willInGem > 0.0)) continue;
                    filledGem.fillWill(type, outputStack, willInGem, true);
                }
            }
        }
    }

    public double consumeSouls(EnumDemonWillType type, double requested) {
        double consumed = 0.0;
        for (int i = 0; i <= 4; ++i) {
            ItemStack soulStack = this.m_8020_(i);
            if (soulStack != null) {
                double souls;
                Object soul;
                if (soulStack.m_41720_() instanceof IDemonWill && ((IDemonWill)soulStack.m_41720_()).getType(soulStack) == type) {
                    soul = (IDemonWill)soulStack.m_41720_();
                    souls = soul.drainWill(type, soulStack, requested - consumed);
                    if (soul.getWill(type, soulStack) <= 0.0) {
                        this.m_6836_(i, ItemStack.f_41583_);
                    }
                    consumed += souls;
                }
                if (soulStack.m_41720_() instanceof IDemonWillGem) {
                    soul = (IDemonWillGem)soulStack.m_41720_();
                    souls = soul.drainWill(type, soulStack, requested - consumed, true);
                    consumed += souls;
                }
            }
            if (!(consumed >= requested)) continue;
            return consumed;
        }
        return consumed;
    }

    public void consumeInventory() {
        for (int i = 0; i < 4; ++i) {
            ItemStack inputStack = this.m_8020_(i);
            if (inputStack.m_41619_()) continue;
            if (inputStack.m_41720_().hasCraftingRemainingItem(inputStack)) {
                this.m_6836_(i, inputStack.m_41720_().getCraftingRemainingItem(inputStack));
                continue;
            }
            inputStack.m_41774_(1);
            if (!inputStack.m_41619_()) continue;
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        ItemStack stack = this.m_8020_(4);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.m_41720_();
        return willGem.fillWill(type, stack, amount, doFill);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        ItemStack stack = this.m_8020_(4);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.m_41720_();
        double drained = amount;
        double current = willGem.getWill(type, stack);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            drained = willGem.drainWill(type, stack, drained, true);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return 0.0;
    }

    public boolean getWillFlagForGUI() {
        return this.showWillFlag;
    }
}

