/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockInversionPillarEnd;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.type.PillarCapType;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileDungeonController;
import wayoftime.bloodmagic.common.tile.base.TileBase;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.ChatUtil;

public class TileInversionPillar
extends TileBase
implements CommandSource {
    protected BlockPos teleportPos = BlockPos.f_121853_;
    protected ResourceKey<Level> destinationKey;

    public TileInversionPillar(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileInversionPillar(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.INVERSION_PILLAR_TYPE.get(), pos, state);
    }

    public void setDestination(Level destinationWorld, BlockPos destinationPos) {
        BMLog.DEFAULT.info("Pillar at {} set to {} in {}", this.m_58899_(), this.teleportPos, this.destinationKey);
        this.destinationKey = destinationWorld.m_46472_();
        this.teleportPos = destinationPos;
    }

    public boolean hasDestination() {
        return this.teleportPos != BlockPos.f_121853_;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        CompoundTag positionTag = tag.m_128469_("dungeon_teleport_pos");
        this.teleportPos = new BlockPos(positionTag.m_128451_("xCoord"), positionTag.m_128451_("yCoord"), positionTag.m_128451_("zCoord"));
        if (tag.m_128441_("dungeon_teleport_key")) {
            String key = tag.m_128461_("dungeon_teleport_key");
            this.destinationKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(key));
        }
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        CompoundTag positionTag = new CompoundTag();
        positionTag.m_128405_("xCoord", this.teleportPos.m_123341_());
        positionTag.m_128405_("yCoord", this.teleportPos.m_123342_());
        positionTag.m_128405_("zCoord", this.teleportPos.m_123343_());
        tag.m_128365_("dungeon_teleport_pos", (Tag)positionTag);
        if (this.destinationKey != null) {
            tag.m_128359_("dungeon_teleport_key", this.destinationKey.m_135782_().toString());
        }
        return tag;
    }

    public void handlePlayerInteraction(ServerPlayer player) {
        BlockPos pillarPos = this.m_58899_();
        BlockPos controllerPos = pillarPos.m_6630_(2);
        boolean isEndless = this.f_58857_.m_8055_(pillarPos.m_7495_().m_122013_(10)).m_60713_((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
        if (this.f_58857_.m_8055_(controllerPos).m_60713_((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get())) {
            boolean regen = false;
            BlockEntity blockEntity = this.f_58857_.m_7702_(controllerPos);
            if (blockEntity instanceof TileDungeonController) {
                TileDungeonController controller = (TileDungeonController)blockEntity;
                if (controller.dungeon == null || controller.dungeon.availableDoorMasterMap.isEmpty()) {
                    BMLog.DEFAULT.warn("Trouble generating dungeon detected, attempting to fix", new Object[0]);
                    regen = true;
                }
            }
            if (regen) {
                DungeonSynthesizer dungeon = new DungeonSynthesizer();
                dungeon.generateInitialRoom(BloodMagic.rl(isEndless ? "room_pools/entrances/standard_dungeon_entrances" : "room_pools/entrances/mini_dungeon_entrances"), this.f_58857_.f_46441_, (ServerLevel)this.f_58857_, controllerPos);
                this.f_58857_.m_46597_(pillarPos, ((Block)BloodMagicBlocks.INVERSION_PILLAR.get()).m_49966_());
                this.f_58857_.m_46597_(pillarPos.m_121945_(Direction.DOWN), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).m_49966_().m_61124_(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.BOTTOM)));
                this.f_58857_.m_46597_(pillarPos.m_121945_(Direction.UP), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).m_49966_().m_61124_(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.TOP)));
                BlockEntity blockEntity2 = this.f_58857_.m_7702_(pillarPos);
                if (blockEntity2 instanceof TileInversionPillar) {
                    TileInversionPillar tilePillar = (TileInversionPillar)blockEntity2;
                    if (player.getPersistentData().m_128441_("dungeon_exit")) {
                        CompoundTag exit = player.getPersistentData().m_128469_("dungeon_exit");
                        BlockPos exitPos = new BlockPos(exit.m_128451_("xCoord"), exit.m_128451_("yCoord"), exit.m_128451_("zCoord"));
                        ResourceKey exitDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(exit.m_128461_("dimension_key")));
                        tilePillar.setDestination((Level)this.f_58857_.m_7654_().m_129880_(exitDim), exitPos);
                        tilePillar.m_6596_();
                        ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.dungeon.position_fix", (Object[])new Object[]{tilePillar.teleportPos, tilePillar.destinationKey}).m_130940_(ChatFormatting.LIGHT_PURPLE)});
                    }
                }
                ChatUtil.sendNoSpam(player, new Component[]{Component.m_237115_((String)"chat.bloodmagic.dungeon.controller_fix").m_130940_(ChatFormatting.DARK_GREEN)});
                return;
            }
        }
        if (this.teleportPos.equals((Object)BlockPos.f_121853_)) {
            CompoundTag exit = player.getPersistentData().m_128469_("dungeon_exit");
            this.teleportPos = new BlockPos(exit.m_128451_("xCoord"), exit.m_128451_("yCoord"), exit.m_128451_("zCoord"));
            this.destinationKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(exit.m_128461_("dimension_key")));
            this.m_6596_();
            ChatUtil.sendNoSpam(player, new Component[]{Component.m_237110_((String)"chat.bloodmagic.dungeon.position_fix", (Object[])new Object[]{this.teleportPos, this.destinationKey}).m_130940_(ChatFormatting.DARK_PURPLE)});
            return;
        }
        this.teleportPlayerToLocation((ServerLevel)this.f_58857_, (Player)player, this.destinationKey, this.teleportPos);
    }

    public CommandSourceStack getCommandSource(ServerLevel world) {
        return new CommandSourceStack((CommandSource)this, new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), Vec2.f_82462_, world, 2, "Inversion Pillar", (Component)Component.m_237113_((String)"Inversion Pillar"), world.m_7654_(), (Entity)null);
    }

    public void teleportPlayerToLocation(ServerLevel serverWorld, Player player, ResourceKey<Level> destination, BlockPos destinationPos) {
        String command = this.getTextCommandForTeleport(destination, player, (double)destinationPos.m_123341_() + 0.5, destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5);
        MinecraftServer mcServer = serverWorld.m_7654_();
        mcServer.m_129892_().m_230957_(this.getCommandSource(serverWorld), command);
    }

    public String getTextCommandForTeleport(ResourceKey<Level> destination, Player player, double posX, double posY, double posZ) {
        String playerName = player.m_7755_().getString();
        return "execute in " + destination.m_135782_().toString() + " run teleport " + playerName + " " + posX + " " + posY + " " + posZ;
    }

    public void m_213846_(Component component) {
    }

    public boolean m_6999_() {
        return false;
    }

    public boolean m_7028_() {
        return false;
    }

    public boolean m_6102_() {
        return false;
    }
}

