/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.data.recipe.builder.ARCPotionRecipeBuilder;
import wayoftime.bloodmagic.common.data.recipe.builder.ARCRecipeBuilder;
import wayoftime.bloodmagic.common.fluid.BloodMagicFluids;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.recipe.ISubRecipeProvider;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class ARCRecipeProvider
implements ISubRecipeProvider {
    private static final Ingredient hydration = Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_HYDRATE);
    private static final FluidStackIngredient water = FluidStackIngredient.from((Fluid)Fluids.f_76193_, 200);
    private static final FluidStackIngredient cauldron_use = FluidStackIngredient.from((Fluid)Fluids.f_76193_, 333);

    @Override
    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "arc/";
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41834_}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "ore/dustiron"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41833_}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "ore/dustgold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.NETHERRACK), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.SULFUR.get()), new FluidStack((Fluid)Fluids.f_76195_, 50)).build(consumer, BloodMagic.rl(basePath + "netherrack_to_sulfer"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42199_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50129_), null).build(consumer, BloodMagic.rl(basePath + "clay_from_terracotta"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.SAND), hydration, water, new ItemStack((ItemLike)Items.f_42461_), null).addRandomOutput(new ItemStack((ItemLike)Items.f_42461_), 0.5).build(consumer, BloodMagic.rl(basePath + "clay_from_sand"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_}), hydration, water, new ItemStack((ItemLike)Blocks.f_220864_), null).build(consumer, BloodMagic.rl(basePath + "mud_from_dirt"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50652_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50079_), null).build(consumer, BloodMagic.rl(basePath + "mossify_cobblestone"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50409_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50647_), null).build(consumer, BloodMagic.rl(basePath + "mossify_cobblestone_slab"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50157_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50633_), null).build(consumer, BloodMagic.rl(basePath + "mossify_cobblestone_stairs"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50274_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50275_), null).build(consumer, BloodMagic.rl(basePath + "mossify_cobblestone_wall"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50222_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50223_), null).build(consumer, BloodMagic.rl(basePath + "mossify_stone_bricks"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50411_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50645_), null).build(consumer, BloodMagic.rl(basePath + "mossify_stone_brick_slab"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50194_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50631_), null).build(consumer, BloodMagic.rl(basePath + "mossify_stone_brick_stairs"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50609_}), hydration, water, new ItemStack((ItemLike)Blocks.f_50607_), null).build(consumer, BloodMagic.rl(basePath + "mossify_stone_brick_wall"));
        this.oxidize(consumer, Blocks.f_152504_, Blocks.f_152503_, Blocks.f_152502_, Blocks.f_152501_);
        this.oxidize(consumer, Blocks.f_152510_, Blocks.f_152509_, Blocks.f_152508_, Blocks.f_152507_);
        this.oxidize(consumer, Blocks.f_152566_, Blocks.f_152565_, Blocks.f_152564_, Blocks.f_152563_);
        this.oxidize(consumer, Blocks.f_152570_, Blocks.f_152569_, Blocks.f_152568_, Blocks.f_152567_);
        this.solidifyConcrete(consumer, Blocks.f_50506_, Blocks.f_50542_);
        this.solidifyConcrete(consumer, Blocks.f_50507_, Blocks.f_50543_);
        this.solidifyConcrete(consumer, Blocks.f_50508_, Blocks.f_50544_);
        this.solidifyConcrete(consumer, Blocks.f_50509_, Blocks.f_50545_);
        this.solidifyConcrete(consumer, Blocks.f_50510_, Blocks.f_50494_);
        this.solidifyConcrete(consumer, Blocks.f_50511_, Blocks.f_50495_);
        this.solidifyConcrete(consumer, Blocks.f_50512_, Blocks.f_50496_);
        this.solidifyConcrete(consumer, Blocks.f_50513_, Blocks.f_50497_);
        this.solidifyConcrete(consumer, Blocks.f_50514_, Blocks.f_50498_);
        this.solidifyConcrete(consumer, Blocks.f_50515_, Blocks.f_50499_);
        this.solidifyConcrete(consumer, Blocks.f_50516_, Blocks.f_50500_);
        this.solidifyConcrete(consumer, Blocks.f_50517_, Blocks.f_50501_);
        this.solidifyConcrete(consumer, Blocks.f_50518_, Blocks.f_50502_);
        this.solidifyConcrete(consumer, Blocks.f_50519_, Blocks.f_50503_);
        this.solidifyConcrete(consumer, Blocks.f_50573_, Blocks.f_50504_);
        this.solidifyConcrete(consumer, Blocks.f_50574_, Blocks.f_50505_);
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)ItemTags.f_13146_), hydration, cauldron_use, new ItemStack((ItemLike)Items.f_42503_), null).build(consumer, BloodMagic.rl(basePath + "wash_bed"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)ItemTags.f_13167_), hydration, cauldron_use, new ItemStack((ItemLike)Items.f_41870_), null).build(consumer, BloodMagic.rl(basePath + "wash_wool"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)ItemTags.f_215867_), hydration, cauldron_use, new ItemStack((ItemLike)Items.f_42130_), null).build(consumer, BloodMagic.rl(basePath + "wash_carpet"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.GLASS), hydration, cauldron_use, new ItemStack((ItemLike)Items.f_41904_), null).build(consumer, BloodMagic.rl(basePath + "wash_glass"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.GLASS_PANES), hydration, cauldron_use, new ItemStack((ItemLike)Items.f_42027_), null).build(consumer, BloodMagic.rl(basePath + "wash_glass_pane"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.WEAK_TAU_ITEM.get()}), hydration, FluidStackIngredient.from((Fluid)BloodMagicFluids.LIFE_ESSENCE_FLUID.get(), 1600), new ItemStack((ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get()), null).build(consumer, BloodMagic.rl(basePath + "strengthen_tau"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.STRONG_TAU_ITEM.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()), 0.2).build(consumer, BloodMagic.rl(basePath + "weakbloodshard_tau"));
        ARCPotionRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.THROWING_DAGGER_COPPER.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get()}), null, new ItemStack((ItemLike)BloodMagicItems.THROWING_DAGGER_COPPER_POTION.get(), 8), null).setRequiredInputCount(8).build(consumer, BloodMagic.rl(basePath + "tipped_copper"));
        this.addReversionRecipes(consumer);
        this.addSandRecipes(consumer);
        this.addFragmentRecipes(consumer);
        this.addGravelRecipes(consumer);
    }

    private void solidifyConcrete(Consumer<FinishedRecipe> consumer, Block powder, Block concrete) {
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{powder}), hydration, water, new ItemStack((ItemLike)concrete), null).build(consumer, BloodMagic.rl("arc/solidify_" + ForgeRegistries.BLOCKS.getKey((Object)concrete).m_135815_()));
    }

    private void oxidize(Consumer<FinishedRecipe> consumer, Block start, Block exposed, Block weathered, Block oxidized) {
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{start}), hydration, water, new ItemStack((ItemLike)exposed), null).build(consumer, BloodMagic.rl("arc/oxidize/" + ForgeRegistries.BLOCKS.getKey((Object)start).m_135815_() + "_to_" + ForgeRegistries.BLOCKS.getKey((Object)exposed).m_135815_()));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{exposed}), hydration, water, new ItemStack((ItemLike)weathered), null).build(consumer, BloodMagic.rl("arc/oxidize/" + ForgeRegistries.BLOCKS.getKey((Object)exposed).m_135815_() + "_to_" + ForgeRegistries.BLOCKS.getKey((Object)weathered).m_135815_()));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{weathered}), hydration, water, new ItemStack((ItemLike)oxidized), null).build(consumer, BloodMagic.rl("arc/oxidize/" + ForgeRegistries.BLOCKS.getKey((Object)weathered).m_135815_() + "_to_" + ForgeRegistries.BLOCKS.getKey((Object)oxidized).m_135815_()));
    }

    private ICondition getTagCondition(TagKey<Item> tag) {
        return new NotCondition((ICondition)new TagEmptyCondition(tag.f_203868_()));
    }

    private void addSandRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "arc/dusts";
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get()), 0.33, 0.17).build(consumer, BloodMagic.rl(basePath + "from_raw_iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get()), 0.33, 0.17).build(consumer, BloodMagic.rl(basePath + "from_raw_gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_SAND.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.COPPER_SAND.get()), 0.33, 0.17).build(consumer, BloodMagic.rl(basePath + "from_raw_copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.RAW_HELLFORGED), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()), 0.33, 0.17).build(consumer, BloodMagic.rl(basePath + "from_raw_hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "from_ore_iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "from_ore_gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "from_ore_copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.ORE_HELLFORGED), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_SAND.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "from_ore_hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_NETHERITE_SCRAP), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get(), 2), null).build(consumer, BloodMagic.rl(basePath + "from_ore_netherite_scrap"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_ingot_iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_ingot_gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_ingot_copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.INGOT_HELLFORGED), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_ingot_hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42419_}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_ingot_netherite_scrap"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.GRAVEL_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.IRON_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_gravel_iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.GRAVEL_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_gravel_gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.GRAVEL_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_gravel_copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.GRAVEL_DEMONITE), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_gravel_hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.GRAVEL_NETHERITE_SCRAP), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_CUTTINGFLUID), null, new ItemStack((ItemLike)BloodMagicItems.NETHERITE_SCRAP_SAND.get()), null).build(consumer, BloodMagic.rl(basePath + "from_gravel_netherite_scrap"));
    }

    private void addFragmentRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "arc/fragments";
        double rawToFragmentExtra = 0.25;
        double oreToFragmentExtra = 0.5;
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.IRON_FRAGMENT.get(), 2), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.IRON_FRAGMENT.get()), rawToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get(), 2), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get()), rawToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.RAW_MATERIALS_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get(), 2), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get()), rawToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.RAW_HELLFORGED), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.DEMONITE_FRAGMENT.get(), 2), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.DEMONITE_FRAGMENT.get()), rawToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.IRON_FRAGMENT.get(), 4), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.IRON_FRAGMENT.get()), oreToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "from_ore_iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get(), 4), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.GOLD_FRAGMENT.get()), oreToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "from_ore_gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get(), 4), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.COPPER_FRAGMENT.get()), oreToFragmentExtra).build(consumer, BloodMagic.rl(basePath + "from_ore_copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_((TagKey)Tags.Items.ORES_NETHERITE_SCRAP), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_EXPLOSIVE), null, new ItemStack((ItemLike)BloodMagicItems.NETHERITE_SCRAP_FRAGMENT.get(), 3), null).build(consumer, BloodMagic.rl(basePath + "netherite_scrap"));
    }

    private void addGravelRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "arc/gravels";
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.FRAGMENT_IRON), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_RESONATOR), null, new ItemStack((ItemLike)BloodMagicItems.IRON_GRAVEL.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()), 0.5).build(consumer, BloodMagic.rl(basePath + "iron"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.FRAGMENT_GOLD), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_RESONATOR), null, new ItemStack((ItemLike)BloodMagicItems.GOLD_GRAVEL.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()), 0.5).build(consumer, BloodMagic.rl(basePath + "gold"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.FRAGMENT_COPPER), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_RESONATOR), null, new ItemStack((ItemLike)BloodMagicItems.COPPER_GRAVEL.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()), 0.25).build(consumer, BloodMagic.rl(basePath + "copper"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.FRAGMENT_DEMONITE), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_RESONATOR), null, new ItemStack((ItemLike)BloodMagicItems.DEMONITE_GRAVEL.get()), null).build(consumer, BloodMagic.rl(basePath + "hellforged"));
        ARCRecipeBuilder.arc(Ingredient.m_204132_(BloodMagicTags.FRAGMENT_NETHERITE_SCRAP), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_RESONATOR), null, new ItemStack((ItemLike)BloodMagicItems.NETHERITE_SCRAP_GRAVEL.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()), 0.5).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.CORRUPTED_DUST_TINY.get()), 0.5).build(consumer, BloodMagic.rl(basePath + "netherite_scrap"));
    }

    private void addReversionRecipes(Consumer<FinishedRecipe> consumer) {
        String basePath = "arc/reversion/";
        this.registerReversionRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()}), new ItemStack((ItemLike)Items.f_42415_), consumer, basePath + "weak_blood_orb");
        this.registerReversionRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()}), new ItemStack((ItemLike)Blocks.f_50330_), consumer, basePath + "apprentice_blood_orb");
        this.registerReversionRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()}), new ItemStack((ItemLike)Blocks.f_50074_), consumer, basePath + "magician_blood_orb");
        this.registerReversionRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()}), new ItemStack((ItemLike)BloodMagicItems.WEAK_BLOOD_SHARD.get()), consumer, basePath + "master_blood_orb");
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.SELF_SACRIFICE_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.SELF_SACRIFICE_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "self_sac"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.ACCELERATION_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.ACCELERATION_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "acceleration"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.AUGMENTED_CAPACITY_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.AUGMENTED_CAPACITY_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "aug_capacity"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.CAPACITY_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.CAPACITY_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "capacity"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.CHARGING_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.CHARGING_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "charging"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.DISPLACEMENT_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.DISPLACEMENT_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "displacement"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.ORB_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.ORB_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "orb_rune"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.SPEED_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.SPEED_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "speed"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicBlocks.SACRIFICE_RUNE_2.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicBlocks.SACRIFICE_RUNE.get()), null).addRandomOutput(new ItemStack((ItemLike)BloodMagicItems.HELLFORGED_PARTS.get()), 1.0, 0.0).addRandomOutput(new ItemStack((ItemLike)Items.f_42419_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "sac"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)Items.f_42419_, 4), null).addRandomOutput(new ItemStack((ItemLike)Items.f_42417_, 4), 1.0, 0.0).build(consumer, BloodMagic.rl(basePath + "netherite_ingot"));
        ARCRecipeBuilder.arc(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BloodMagicItems.BLEEDING_EDGE_MUSIC.get()}), Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, new ItemStack((ItemLike)BloodMagicItems.DEMONITE_RAW.get(), 9), null).build(consumer, BloodMagic.rl(basePath + "bleeding_edge"));
    }

    private void registerReversionRecipe(Ingredient input, ItemStack outputStack, Consumer<FinishedRecipe> consumer, String path) {
        ARCRecipeBuilder.arcConsume(input, Ingredient.m_204132_(BloodMagicTags.ARC_TOOL_REVERTER), null, outputStack, null).build(consumer, BloodMagic.rl(path));
    }
}

