/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillWeapon;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.common.item.BMItemTier;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSentientShovel
extends ShovelItem
implements IDemonWillWeapon,
IMultiWillTool {
    public static int[] soulBracket = new int[]{16, 60, 200, 400, 1000, 2000, 4000};
    public static double[] defaultDamageAdded = new double[]{1.0, 2.0, 3.0, 3.5, 4.0, 4.5, 5.0};
    public static double[] destructiveDamageAdded = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    public static double[] vengefulDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] steadfastDamageAdded = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
    public static double[] defaultDigSpeedAdded = new double[]{1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0};
    public static double[] soulDrainPerSwing = new double[]{0.05, 0.1, 0.2, 0.4, 0.75, 1.0, 1.25};
    public static double[] soulDrop = new double[]{2.0, 4.0, 7.0, 10.0, 13.0, 15.0, 18.0};
    public static double[] staticDrop = new double[]{1.0, 1.0, 2.0, 3.0, 3.0, 4.0, 4.0};
    public static double[] healthBonus = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public static double[] vengefulAttackSpeed = new double[]{-3.0, -2.8, -2.7, -2.6, -2.5, -2.4, -2.3};
    public static double[] destructiveAttackSpeed = new double[]{-3.1, -3.1, -3.2, -3.3, -3.3, -3.3, -3.3};
    public static int[] absorptionTime = new int[]{200, 300, 400, 500, 600, 700, 800};
    public static double maxAbsorptionHearts = 10.0;
    public static int[] poisonTime = new int[]{25, 50, 60, 80, 100, 120, 150};
    public static int[] poisonLevel = new int[]{0, 0, 0, 1, 1, 1, 1};
    public static double[] movementSpeed = new double[]{0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4};
    public static final double baseAttackDamage = 3.0;
    public static final double baseAttackSpeed = -2.8;

    public ItemSentientShovel() {
        super((Tier)BMItemTier.SENTIENT, 3.0f, -2.8f, new Item.Properties().m_41503_(520));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BloodMagicTags.CRYSTAL_DEMON) || super.m_6832_(toRepair, repair);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float value = super.m_8102_(stack, state);
        if (value > 1.0f) {
            return (float)((double)value + this.getDigSpeedOfSword(stack));
        }
        return value;
    }

    public void recalculatePowers(ItemStack stack, Level world, Player player) {
        EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType(player);
        double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        this.setCurrentType(stack, soulsRemaining > 0.0 ? type : EnumDemonWillType.DEFAULT);
        int level = this.getLevel(stack, soulsRemaining);
        double drain = level >= 0 ? soulDrainPerSwing[level] : 0.0;
        double extraDamage = this.getExtraDamage(type, level);
        this.setDrainOfActivatedSword(stack, drain);
        this.setDamageOfActivatedSword(stack, 3.0 + extraDamage);
        this.setStaticDropOfActivatedSword(stack, level >= 0 ? staticDrop[level] : 1.0);
        this.setDropOfActivatedSword(stack, level >= 0 ? soulDrop[level] : 0.0);
        this.setAttackSpeedOfSword(stack, level >= 0 ? this.getAttackSpeed(type, level) : -2.8);
        this.setHealthBonusOfSword(stack, level >= 0 ? this.getHealthBonus(type, level) : 0.0);
        this.setSpeedOfSword(stack, level >= 0 ? this.getMovementSpeed(type, level) : 0.0);
        this.setDigSpeedOfSword(stack, level >= 0 ? this.getDigSpeed(type, level) : 0.0);
    }

    public double getExtraDamage(EnumDemonWillType type, int willBracket) {
        if (willBracket < 0) {
            return 0.0;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return defaultDamageAdded[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveDamageAdded[willBracket];
            }
            case VENGEFUL: {
                return vengefulDamageAdded[willBracket];
            }
            case STEADFAST: {
                return steadfastDamageAdded[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return vengefulAttackSpeed[willBracket];
            }
            case DESTRUCTIVE: {
                return destructiveAttackSpeed[willBracket];
            }
        }
        return -2.9;
    }

    public double getHealthBonus(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return healthBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getMovementSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return movementSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public double getDigSpeed(EnumDemonWillType type, int willBracket) {
        switch (type) {
            default: 
        }
        return defaultDigSpeedAdded[willBracket];
    }

    public void applyEffectToEntity(EnumDemonWillType type, int willBracket, LivingEntity target, Player attacker) {
        switch (type) {
            case CORROSIVE: {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, poisonTime[willBracket], poisonLevel[willBracket]));
                break;
            }
            case DEFAULT: {
                break;
            }
            case DESTRUCTIVE: {
                break;
            }
            case STEADFAST: {
                if (target.m_6084_()) break;
                float absorption = attacker.m_6103_();
                attacker.m_7292_(new MobEffectInstance(MobEffects.f_19617_, absorptionTime[willBracket], 127));
                attacker.m_7911_((float)Math.min((double)(absorption + target.m_21233_() * 0.05f), maxAbsorptionHearts));
                break;
            }
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (super.m_7579_(stack, target, attacker)) {
            if (attacker instanceof Player) {
                Player attackerPlayer = (Player)attacker;
                this.recalculatePowers(stack, attackerPlayer.m_20193_(), attackerPlayer);
                EnumDemonWillType type = this.getCurrentType(stack);
                double will = PlayerDemonWillHandler.getTotalDemonWill(type, attackerPlayer);
                int willBracket = this.getLevel(stack, will);
                this.applyEffectToEntity(type, willBracket, target, attackerPlayer);
            }
            return true;
        }
        return false;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.m_128461_("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(ItemStack stack, EnumDemonWillType type) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_("demonWillType", type.toString());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        this.recalculatePowers(player.m_21120_(hand), world, player);
        return super.m_7203_(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    private int getLevel(ItemStack stack, double soulsRemaining) {
        int lvl = -1;
        for (int i = 0; i < soulBracket.length; ++i) {
            if (!(soulsRemaining >= (double)soulBracket[i])) continue;
            lvl = i;
        }
        return lvl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.sentientShovel.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        this.recalculatePowers(stack, player.m_20193_(), player);
        double drain = this.getDrainOfActivatedSword(stack);
        if (drain > 0.0) {
            EnumDemonWillType type = this.getCurrentType(stack);
            double soulsRemaining = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (drain > soulsRemaining) {
                return false;
            }
            PlayerDemonWillHandler.consumeDemonWill(type, player, drain);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    @Override
    public List<ItemStack> getRandomDemonWillDrop(LivingEntity killedEntity, LivingEntity attackingEntity, ItemStack stack, int looting) {
        ArrayList<ItemStack> soulList = new ArrayList<ItemStack>();
        if (killedEntity.m_20193_().m_46791_() != Difficulty.PEACEFUL && !(killedEntity instanceof Enemy)) {
            return soulList;
        }
        double willModifier = killedEntity instanceof Slime ? 0.67 : 1.0;
        EnumDemonWillType type = this.getCurrentType(stack);
        IDemonWill soul = switch (type) {
            case EnumDemonWillType.CORROSIVE -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_CORROSIVE.get();
            case EnumDemonWillType.DESTRUCTIVE -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_DESTRUCTIVE.get();
            case EnumDemonWillType.STEADFAST -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_STEADFAST.get();
            case EnumDemonWillType.VENGEFUL -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_VENGEFUL.get();
            default -> (IDemonWill)BloodMagicItems.MONSTER_SOUL_RAW.get();
        };
        for (int i = 0; i <= looting; ++i) {
            if (i != 0 && !(attackingEntity.m_20193_().f_46441_.m_188500_() < 0.4)) continue;
            ItemStack soulStack = soul.createWill(willModifier * (this.getDropOfActivatedSword(stack) * attackingEntity.m_20193_().f_46441_.m_188500_() + this.getStaticDropOfActivatedSword(stack)) * (double)killedEntity.m_21233_() / 20.0);
            soulList.add(soulStack);
        }
        return soulList;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.getDamageOfActivatedSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(new UUID(0L, 31818145L), "Weapon modifier", this.getHealthBonusOfSword(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(new UUID(0L, 4218052L), "Weapon modifier", this.getSpeedOfSword(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public double getDamageOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDamage");
    }

    public void setDamageOfActivatedSword(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDamage", damage);
    }

    public double getDrainOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordActiveDrain");
    }

    public void setDrainOfActivatedSword(ItemStack stack, double drain) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordActiveDrain", drain);
    }

    public double getStaticDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordStaticDrop");
    }

    public void setStaticDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordStaticDrop", drop);
    }

    public double getDropOfActivatedSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDrop");
    }

    public void setDropOfActivatedSword(ItemStack stack, double drop) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDrop", drop);
    }

    public double getHealthBonusOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordHealth");
    }

    public void setHealthBonusOfSword(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordHealth", hp);
    }

    public double getAttackSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordAttackSpeed");
    }

    public void setAttackSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordAttackSpeed", speed);
    }

    public double getSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordSpeed");
    }

    public void setSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordSpeed", speed);
    }

    public double getDigSpeedOfSword(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("soulSwordDigSpeed");
    }

    public void setDigSpeedOfSword(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("soulSwordDigSpeed", speed);
    }
}

