/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.ModFilterKey;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemModFilter
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.bloodmagic.filter.mod");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.modfilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        boolean sneaking = Screen.m_96638_();
        if (!sneaking) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.extraInfo").m_130940_(ChatFormatting.BLUE));
        } else {
            boolean isWhitelist;
            int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
            boolean bl = isWhitelist = whitelistState == 0;
            if (isWhitelist) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
            }
            InventoryFilter inv = ItemModFilter.getInv(filterStack);
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                MutableComponent modText = Component.m_237110_((String)"tooltip.bloodmagic.filter.from_mod", (Object[])new Object[]{ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135827_()});
                if (isWhitelist) {
                    int amount = GhostItemHelper.getItemGhostAmount(stack);
                    if (amount > 0) {
                        tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.filter.count", (Object[])new Object[]{amount, modText}));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.filter.all", (Object[])new Object[]{modText}));
                    continue;
                }
                tooltip.add((Component)modText);
            }
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        String namespace = ForgeRegistries.ITEMS.getKey((Object)ghostStack.m_41720_()).m_135827_();
        return new ModFilterKey(namespace, amount);
    }
}

