/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockDemonCrystal;
import wayoftime.bloodmagic.common.tile.TileAlchemicalReactionChamber;

public class BlockAlchemicalReactionChamber
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<EnumDemonWillType> TYPE = EnumProperty.m_61587_((String)"type", EnumDemonWillType.class);
    public static final Map<EnumDemonWillType, ItemParticleOption> PARTICLE_MAP = new HashMap<EnumDemonWillType, ItemParticleOption>();

    public BlockAlchemicalReactionChamber() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 5.0f).m_60918_(SoundType.f_56742_).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)EnumDemonWillType.DEFAULT)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAlchemicalReactionChamber(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, tile) -> {
            if (tile instanceof TileAlchemicalReactionChamber) {
                ((TileAlchemicalReactionChamber)tile).tick();
            }
        };
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        TileAlchemicalReactionChamber arc = (TileAlchemicalReactionChamber)world.m_7702_(blockPos);
        if (arc != null) {
            arc.dropItems();
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof TileAlchemicalReactionChamber) {
                ((TileAlchemicalReactionChamber)tileentity).dropItems();
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileAlchemicalReactionChamber)) {
            return InteractionResult.FAIL;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tile), (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof AbstractFurnaceBlockEntity) {
            ((AbstractFurnaceBlockEntity)tileentity).m_58638_(stack.m_41786_());
        }
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT, TYPE});
    }

    public boolean m_8133_(BlockState state, Level worldIn, BlockPos pos, int id, int param) {
        super.m_8133_(state, worldIn, pos, id, param);
        BlockEntity tileentity = worldIn.m_7702_(pos);
        return tileentity == null ? false : tileentity.m_7531_(id, param);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            ItemParticleOption particleData = this.getParticleData((EnumDemonWillType)((Object)state.m_61143_(TYPE)));
            level.m_7106_((ParticleOptions)particleData, d0 + d5, d1 + d6, d2 + d7, (double)direction.m_122429_() * 0.03, 0.1, (double)direction.m_122431_() * 0.03);
        }
    }

    private ItemParticleOption getParticleData(EnumDemonWillType type) {
        if (!PARTICLE_MAP.containsKey((Object)type)) {
            PARTICLE_MAP.put(type, new ItemParticleOption(ParticleTypes.f_123752_, BlockDemonCrystal.getItemStackDropped(type, 1)));
        }
        return PARTICLE_MAP.get((Object)type);
    }
}

