/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.tile.ContainerItemRoutingNode;
import wayoftime.bloodmagic.common.tile.routing.TileFilteredRoutingNode;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.network.ItemRoutingNodeButtonPacket;

public class ScreenItemRoutingNode
extends ScreenBase<ContainerItemRoutingNode> {
    private static final ResourceLocation background = new ResourceLocation("bloodmagic", "textures/gui/routingnode.png");
    public TileFilteredRoutingNode tileNode;
    private Direction playerFacing;
    private Direction horizontalFacing;
    private int left;
    private int top;
    private List<Button> buttonList = new ArrayList<Button>();

    public ScreenItemRoutingNode(ContainerItemRoutingNode container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tileNode = container.tileNode;
        this.f_97726_ = 176;
        this.f_97727_ = 187;
        Vec3 facingVec = Vec3.m_82503_((Vec2)playerInventory.f_35978_.m_20155_());
        this.playerFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
        this.horizontalFacing = playerInventory.f_35978_.m_6350_();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.f_97726_) / 2;
        this.top = (this.f_96544_ - this.f_97727_) / 2;
        this.m_169413_();
        for (int i = 0; i < 6; ++i) {
            Direction dir = this.getFilterDirectionForButton(i);
            Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
            String dirName = this.getStringForDirection(dir);
            if (!this.tileNode.m_58904_().m_46859_(this.tileNode.getCurrentBlockPos().m_121945_(dir))) {
                dirName = "";
            }
            Button button = Button.m_253074_((Component)Component.m_237113_((String)dirName), (Button.OnPress)new DirectionalPress(this, this.tileNode, i, dir)).m_252794_(this.left + (Integer)buttonLocation.getLeft(), this.top + (Integer)buttonLocation.getRight()).m_253046_(20, 20).m_253136_();
            this.m_142416_((GuiEventListener)button);
            this.buttonList.add(button);
            if (dir.ordinal() != this.tileNode.getCurrentActiveSlot()) continue;
            this.disableDirectionalButton(i);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), (Button.OnPress)new IncrementPress(this.tileNode, 6)).m_252794_(this.left + 89, this.top + 50).m_253046_(8, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), (Button.OnPress)new IncrementPress(this.tileNode, 7)).m_252794_(this.left + 61, this.top + 50).m_253046_(8, 20).m_253136_());
    }

    public Direction getFilterDirectionForButton(int button) {
        if (button == 2) {
            return this.playerFacing;
        }
        if (button == 5) {
            return this.playerFacing.m_122424_();
        }
        if (this.playerFacing == Direction.UP) {
            switch (button) {
                case 0: {
                    return this.horizontalFacing.m_122424_();
                }
                case 4: {
                    return this.horizontalFacing;
                }
                case 1: {
                    return this.horizontalFacing.m_122428_();
                }
                case 3: {
                    return this.horizontalFacing.m_122427_();
                }
            }
        } else if (this.playerFacing == Direction.DOWN) {
            switch (button) {
                case 0: {
                    return this.horizontalFacing;
                }
                case 4: {
                    return this.horizontalFacing.m_122424_();
                }
                case 1: {
                    return this.horizontalFacing.m_122428_();
                }
                case 3: {
                    return this.horizontalFacing.m_122427_();
                }
            }
        } else {
            switch (button) {
                case 0: {
                    return Direction.UP;
                }
                case 4: {
                    return Direction.DOWN;
                }
                case 1: {
                    return this.horizontalFacing.m_122428_();
                }
                case 3: {
                    return this.horizontalFacing.m_122427_();
                }
            }
        }
        return Direction.UP;
    }

    public String getStringForDirection(Direction dir) {
        switch (dir) {
            case DOWN: {
                return "D";
            }
            case EAST: {
                return "E";
            }
            case NORTH: {
                return "N";
            }
            case SOUTH: {
                return "S";
            }
            case UP: {
                return "U";
            }
            case WEST: {
                return "W";
            }
        }
        return "";
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("" + this.getCurrentActiveSlotPriority())), 76, 56, 0xFFFFFF, false);
        BlockPos tilePos = this.tileNode.getCurrentBlockPos();
        Level world = this.tileNode.m_58904_();
        for (int i = 0; i < 6; ++i) {
            Direction dir = this.getFilterDirectionForButton(i);
            Pair<Integer, Integer> buttonLocation = this.getButtonLocation(i);
            BlockState blockState = world.m_8055_(tilePos.m_121945_(dir));
            Block block = blockState.m_60734_();
            if (block == null) continue;
            ItemStack itemStack = new ItemStack((ItemLike)block);
            this.drawItemStack(guiGraphics, itemStack, (Integer)buttonLocation.getLeft() + 2, (Integer)buttonLocation.getRight() + 2, this.getStringForDirection(dir));
        }
    }

    public Pair<Integer, Integer> getButtonLocation(int button) {
        switch (button) {
            case 0: {
                return Pair.of((Object)129, (Object)11);
            }
            case 1: {
                return Pair.of((Object)109, (Object)31);
            }
            case 2: {
                return Pair.of((Object)129, (Object)31);
            }
            case 3: {
                return Pair.of((Object)149, (Object)31);
            }
            case 4: {
                return Pair.of((Object)129, (Object)51);
            }
            case 5: {
                return Pair.of((Object)149, (Object)51);
            }
        }
        return Pair.of((Object)0, (Object)0);
    }

    private int getCurrentActiveSlotPriority() {
        Direction direction = Direction.m_122376_((int)this.tileNode.getCurrentActiveSlot());
        if (direction != null) {
            return this.tileNode.getPriority(direction);
        }
        return 0;
    }

    private void enableAllDirectionalButtons() {
        for (AbstractWidget abstractWidget : this.buttonList) {
            abstractWidget.f_93623_ = true;
        }
    }

    private void disableDirectionalButton(int id) {
        this.buttonList.get((int)id).f_93623_ = false;
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(background, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String altText) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        Font font = null;
        if (font == null) {
            font = this.f_96547_;
        }
        guiGraphics.m_280480_(stack, x, y);
        int offset = 8;
        guiGraphics.m_280302_(font, stack, x, y - offset, altText);
        guiGraphics.m_280168_().m_85849_();
    }

    public class DirectionalPress
    implements Button.OnPress {
        private final ScreenItemRoutingNode screen;
        private final TileFilteredRoutingNode node;
        private final int id;
        private final Direction direction;

        public DirectionalPress(ScreenItemRoutingNode screen, TileFilteredRoutingNode node, int id, Direction direction) {
            this.screen = screen;
            this.node = node;
            this.id = id;
            this.direction = direction;
        }

        public void m_93750_(Button button) {
            if (button.f_93623_) {
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new ItemRoutingNodeButtonPacket(this.node.m_58899_(), this.direction.ordinal()));
                if (this.id < 6) {
                    ScreenItemRoutingNode.this.tileNode.setCurrentActiveSlot(this.direction.ordinal());
                    this.screen.enableAllDirectionalButtons();
                    this.screen.disableDirectionalButton(this.id);
                }
            }
        }
    }

    public class IncrementPress
    implements Button.OnPress {
        private final TileFilteredRoutingNode node;
        private final int id;

        public IncrementPress(TileFilteredRoutingNode node, int id) {
            this.node = node;
            this.id = id;
        }

        public void m_93750_(Button button) {
            if (button.f_93623_) {
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new ItemRoutingNodeButtonPacket(this.node.m_58899_(), this.id));
            }
        }
    }
}

