/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.anointment.AnointmentColor;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.client.model.MimicColor;
import wayoftime.bloodmagic.client.model.MimicModelLoader;
import wayoftime.bloodmagic.client.model.SigilHoldingModelLoader;
import wayoftime.bloodmagic.client.render.BloodMagicModelLayerLocations;
import wayoftime.bloodmagic.client.render.RenderItemRoutingNode;
import wayoftime.bloodmagic.client.render.alchemyarray.BeaconAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.DayAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.LowStaticAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.NightAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.alchemyarray.StaticAlchemyCircleRenderer;
import wayoftime.bloodmagic.client.render.block.RenderAlchemyArray;
import wayoftime.bloodmagic.client.render.block.RenderAltar;
import wayoftime.bloodmagic.client.render.block.RenderDemonCrucible;
import wayoftime.bloodmagic.client.render.entity.BloodLightRenderer;
import wayoftime.bloodmagic.client.render.entity.EntityMeteorRenderer;
import wayoftime.bloodmagic.client.render.entity.EntityShapedChargeRenderer;
import wayoftime.bloodmagic.client.render.entity.EntityThrowingDaggerRenderer;
import wayoftime.bloodmagic.client.render.entity.SoulSnareRenderer;
import wayoftime.bloodmagic.client.render.entity.layers.BloodElytraLayer;
import wayoftime.bloodmagic.client.render.model.ModelMeteor;
import wayoftime.bloodmagic.client.screens.ScreenAlchemicalReactionChamber;
import wayoftime.bloodmagic.client.screens.ScreenAlchemyTable;
import wayoftime.bloodmagic.client.screens.ScreenFilter;
import wayoftime.bloodmagic.client.screens.ScreenHolding;
import wayoftime.bloodmagic.client.screens.ScreenItemRoutingNode;
import wayoftime.bloodmagic.client.screens.ScreenMasterRoutingNode;
import wayoftime.bloodmagic.client.screens.ScreenSoulForge;
import wayoftime.bloodmagic.client.screens.ScreenTeleposer;
import wayoftime.bloodmagic.client.screens.ScreenTrainingBracelet;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ItemSacrificialDagger;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilToggleable;
import wayoftime.bloodmagic.common.item.soul.ItemSentientSword;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRendererRegistry;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.network.SigilHoldingPacket;
import wayoftime.bloodmagic.potion.FlaskColor;
import wayoftime.bloodmagic.potion.TippedDaggerColor;
import wayoftime.bloodmagic.util.GhostItemHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BloodMagicModelLayerLocations.METEOR_LOC, ModelMeteor::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerModels(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.ALTAR_TYPE.get(), RenderAltar::new);
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.ALCHEMY_ARRAY_TYPE.get(), RenderAlchemyArray::new);
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.DEMON_CRUCIBLE_TYPE.get(), RenderDemonCrucible::new);
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.ROUTING_NODE_TYPE.get(), RenderItemRoutingNode::new);
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.INPUT_ROUTING_NODE_TYPE.get(), RenderItemRoutingNode::new);
        event.registerBlockEntityRenderer((BlockEntityType)BloodMagicTileEntities.OUTPUT_ROUTING_NODE_TYPE.get(), RenderItemRoutingNode::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.SNARE.getEntityType(), SoulSnareRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.THROWING_DAGGER.getEntityType(), EntityThrowingDaggerRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.THROWING_DAGGER_SYRINGE.getEntityType(), EntityThrowingDaggerRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.BLOOD_LIGHT.getEntityType(), BloodLightRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), EntityShapedChargeRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.METEOR.getEntityType(), EntityMeteorRenderer::new);
        event.registerEntityRenderer(BloodMagicEntityTypes.FLASK.getEntityType(), SoulSnareRenderer::new);
    }

    public static void registerContainerScreens() {
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.SOUL_FORGE_CONTAINER.get()), ScreenSoulForge::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.ARC_CONTAINER.get()), ScreenAlchemicalReactionChamber::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.ALCHEMY_TABLE_CONTAINER.get()), ScreenAlchemyTable::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.HOLDING_CONTAINER.get()), ScreenHolding::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.FILTER_CONTAINER.get()), ScreenFilter::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.ROUTING_NODE_CONTAINER.get()), ScreenItemRoutingNode::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.TRAINING_BRACELET_CONTAINER.get()), ScreenTrainingBracelet::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.TELEPOSER_CONTAINER.get()), ScreenTeleposer::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BloodMagicBlocks.MASTER_ROUTING_NODE_CONTAINER.get()), ScreenMasterRoutingNode::new);
    }

    public static void colorHandlerEvent(RegisterColorHandlersEvent.Item event) {
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), (ItemLike)BloodMagicItems.SILK_TOUCH_ANOINTMENT.get(), (ItemLike)BloodMagicItems.FORTUNE_ANOINTMENT.get(), (ItemLike)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), (ItemLike)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT.get(), (ItemLike)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), (ItemLike)BloodMagicItems.LOOTING_ANOINTMENT.get(), (ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), (ItemLike)BloodMagicItems.WILL_POWER_ANOINTMENT.get(), (ItemLike)BloodMagicItems.SMELTING_ANOINTMENT.get(), (ItemLike)BloodMagicItems.BOW_VELOCITY_ANOINTMENT.get(), (ItemLike)BloodMagicItems.VOIDING_ANOINTMENT.get(), (ItemLike)BloodMagicItems.WEAPON_REPAIR_ANOINTMENT.get()});
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT_STRONG.get()});
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.SILK_TOUCH_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.FORTUNE_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.HOLY_WATER_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.QUICK_DRAW_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.LOOTING_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.SMELTING_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.VOIDING_ANOINTMENT_L.get()});
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.FORTUNE_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.HOLY_WATER_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.QUICK_DRAW_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.LOOTING_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_2.get()});
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.SILK_TOUCH_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.FORTUNE_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.HOLY_WATER_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.QUICK_DRAW_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.LOOTING_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.SMELTING_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_XL.get(), (ItemLike)BloodMagicItems.VOIDING_ANOINTMENT_XL.get()});
        event.getItemColors().m_92689_((ItemColor)new AnointmentColor(), new ItemLike[]{(ItemLike)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.FORTUNE_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.HOLY_WATER_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.QUICK_DRAW_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.LOOTING_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.BOW_POWER_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.WEAPON_REPAIR_ANOINTMENT_2.get(), (ItemLike)BloodMagicItems.WEAPON_REPAIR_ANOINTMENT_3.get(), (ItemLike)BloodMagicItems.WEAPON_REPAIR_ANOINTMENT_L.get(), (ItemLike)BloodMagicItems.WEAPON_REPAIR_ANOINTMENT_XL.get()});
        event.getItemColors().m_92689_((ItemColor)new FlaskColor(), new ItemLike[]{(ItemLike)BloodMagicItems.ALCHEMY_FLASK.get()});
        event.getItemColors().m_92689_((ItemColor)new FlaskColor(), new ItemLike[]{(ItemLike)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get()});
        event.getItemColors().m_92689_((ItemColor)new FlaskColor(), new ItemLike[]{(ItemLike)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get()});
        event.getItemColors().m_92689_((ItemColor)new TippedDaggerColor(), new ItemLike[]{(ItemLike)BloodMagicItems.THROWING_DAGGER_COPPER_POTION.get()});
    }

    public static void cycleSigil(ItemStack stack, Player player, int dWheel) {
        int mode = dWheel;
        if (!((Boolean)ConfigManager.CLIENT.sigilHoldingSkipsEmptySlots.get()).booleanValue()) {
            mode = ItemSigilHolding.getCurrentItemOrdinal(stack);
            mode = dWheel < 0 ? ItemSigilHolding.next(mode) : ItemSigilHolding.prev(mode);
        }
        ItemSigilHolding.cycleToNextSigil(stack, mode);
        BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new SigilHoldingPacket(player.m_150109_().f_35977_, mode));
        ItemStack newStack = ItemSigilHolding.getItemStackInSlot(stack, ItemSigilHolding.getCurrentItemOrdinal(stack));
        player.m_5661_((Component)(newStack.m_41619_() ? Component.m_237113_((String)"") : newStack.m_41611_()), true);
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        Item item;
        ItemStack stack;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.getScrollDelta() != 0.0 && player != null && player.m_6144_() && !(stack = player.m_21205_()).m_41619_() && (item = stack.m_41720_()) instanceof ItemSigilHolding) {
            ClientEvents.cycleSigil(stack, (Player)player, event.getScrollDelta() > 0.0 ? 1 : -1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void appendTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
        AnointmentHolder.appendAnointmentTooltip(holder, event.getToolTip());
        if (GhostItemHelper.hasGhostAmount(stack)) {
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            if (amount == 0) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.bloodmagic.ghost.everything"));
            } else {
                event.getToolTip().add(Component.m_237110_((String)"tooltip.bloodmagic.ghost.amount", (Object[])new Object[]{amount}));
            }
        }
    }

    public static void initClientEvents(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            RenderType rendertype = RenderType.m_110457_();
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.ALCHEMY_TABLE.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.GROWING_DOUBT.get()), (RenderType)rendertype);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.WEAK_TAU.get()), (RenderType)rendertype);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.STRONG_TAU.get()), (RenderType)rendertype);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.SPIKES.get()), (RenderType)rendertype);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.SPECTRAL.get()), (RenderType)RenderType.m_110466_());
            ClientEvents.registerContainerScreens();
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.GREEN_GROVE_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.FAST_MINER_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.MAGNETISM_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.SUPPRESSION_SIGIL.get());
            ClientEvents.registerToggleableProperties((Item)BloodMagicItems.ICE_SIGIL.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SWORD.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_AXE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_PICKAXE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SHOVEL.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.SENTIENT_SCYTHE.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.PETTY_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.LESSER_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.COMMON_GEM.get());
            ClientEvents.registerMultiWillTool((Item)BloodMagicItems.GREATER_GEM.get());
            ClientEvents.registerSacrificialKnife((Item)BloodMagicItems.SACRIFICIAL_DAGGER.get());
            ItemProperties.register((Item)((Item)BloodMagicItems.SENTIENT_SWORD.get()), (ResourceLocation)BloodMagic.rl("active"), (ItemPropertyFunction)new ItemPropertyFunction(){

                public float m_141951_(ItemStack stack, ClientLevel world, LivingEntity entity, int value) {
                    return ((ItemSentientSword)stack.m_41720_()).getActivated(stack) ? 1.0f : 0.0f;
                }
            });
            for (RegistryObject item : BloodMagicItems.DECORATIVE_DUNGEON.getEntries()) {
                ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)BloodMagic.rl("will_type"), (stack, level, entity, value) -> {
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null) {
                        return 0.0f;
                    }
                    CompoundTag stateTag = tag.m_128469_("BlockStateTag");
                    EnumDemonWillType type = EnumDemonWillType.getType(stateTag.m_128461_("will_type"));
                    return type == null ? 0.0f : (float)type.ordinal();
                });
            }
            Minecraft.m_91087_().m_91298_().m_92589_((BlockColor)new MimicColor(), new Block[]{(Block)BloodMagicBlocks.MIMIC.get()});
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BloodMagicBlocks.MIMIC.get()), RenderType2 -> true);
        });
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/movement"), new StaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/movementarray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/updraft"), new BeaconAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/updraftarray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/spike"), new LowStaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/spikearray.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/day"), new DayAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/sunarray.png"), BloodMagic.rl("textures/models/alchemyarrays/sunarrayspikes.png"), BloodMagic.rl("textures/models/alchemyarrays/sunarraycircle.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/night"), new NightAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/moonarrayoutside.png"), BloodMagic.rl("textures/models/alchemyarrays/moonarraysymbols.png"), BloodMagic.rl("textures/models/alchemyarrays/moonarrayinside.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/grove"), new BeaconAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/growthsigil.png")));
        AlchemyArrayRendererRegistry.registerRenderer(BloodMagic.rl("array/bounce"), new LowStaticAlchemyCircleRenderer(BloodMagic.rl("textures/models/alchemyarrays/bouncearray.png")));
    }

    @SubscribeEvent
    public static void initRenderLayer(EntityRenderersEvent.AddLayers event) {
        PlayerRenderer render = (PlayerRenderer)event.getSkin("default");
        render.m_115326_(new BloodElytraLayer(render, event.getEntityModels()));
        render = (PlayerRenderer)event.getSkin("slim");
        render.m_115326_(new BloodElytraLayer(render, event.getEntityModels()));
    }

    @SubscribeEvent
    public static void loadModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register("mimicloader", (IGeometryLoader)new MimicModelLoader(BloodMagic.rl("block/solidopaquemimic")));
        event.register("mimicloader_ethereal", (IGeometryLoader)new MimicModelLoader(BloodMagic.rl("block/etherealopaquemimic")));
        event.register("loader_holding", (IGeometryLoader)new SigilHoldingModelLoader(BloodMagic.rl("item/sigilofholding_base")));
    }

    public static void registerItemModelProperties(FMLClientSetupEvent event) {
    }

    public static void registerToggleableProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)BloodMagic.rl("active"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack stack, ClientLevel world, LivingEntity entity, int val) {
                Item item = stack.m_41720_();
                if (item instanceof ItemSigilToggleable) {
                    return ((ItemSigilToggleable)item).getActivated(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }

    public static void registerMultiWillTool(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)BloodMagic.rl("type"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack stack, ClientLevel world, LivingEntity entity, int val) {
                Item item = stack.m_41720_();
                if (item instanceof IMultiWillTool) {
                    return ((IMultiWillTool)item).getCurrentType(stack).ordinal();
                }
                return 0.0f;
            }
        });
    }

    public static void registerSacrificialKnife(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)BloodMagic.rl("incense"), (ItemPropertyFunction)new ItemPropertyFunction(){

            public float m_141951_(ItemStack stack, ClientLevel world, LivingEntity entity, int val) {
                Item item = stack.m_41720_();
                if (item instanceof ItemSacrificialDagger) {
                    return ((ItemSacrificialDagger)item).canUseForSacrifice(stack) ? 1.0f : 0.0f;
                }
                return 0.0f;
            }
        });
    }
}

