/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.allocs.asm;

import com.ishland.c2me.base.common.util.ASMUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Method;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMTransformerNbtOpsMapBuilderFastUtilMap {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME (c2me-opts-allocs) ASM Transformer");
    private static final String NbtOps$MapBuilder = "net/minecraft/class_2509$class_5320";
    private static final String NbtOps$MapBuilderMapped = ASMUtils.mappingResolver.mapClassName("intermediary", "net/minecraft/class_2509$class_5320".replace('/', '.')).replace('.', '/');
    private static final String buildDesc = "(Lnet/minecraft/class_2487;Lnet/minecraft/class_2520;)Lcom/mojang/serialization/DataResult;";
    private static final String buildDescMapped = ASMUtils.remapMethodDescriptor((String)"(Lnet/minecraft/class_2487;Lnet/minecraft/class_2520;)Lcom/mojang/serialization/DataResult;");
    private static final String build = ASMUtils.mappingResolver.mapMethodName("intermediary", "net/minecraft/class_2509$class_5320".replace('/', '.'), "method_29170", "(Lnet/minecraft/class_2487;Lnet/minecraft/class_2520;)Lcom/mojang/serialization/DataResult;");

    public static void transform(ClassNode classNode) {
        try {
            if (classNode.name.equals(NbtOps$MapBuilderMapped)) {
                for (MethodNode method : classNode.methods) {
                    if (!method.name.equals(build) || !method.desc.equals(buildDescMapped)) continue;
                    LOGGER.debug("Replacing NbtOps$MapBuilder build method newHashMap to fastutil map");
                    ListIterator iterator = method.instructions.iterator();
                    boolean patched = false;
                    while (iterator.hasNext()) {
                        MethodInsnNode methodInsnNode;
                        AbstractInsnNode next = (AbstractInsnNode)iterator.next();
                        if (!(next instanceof MethodInsnNode) || (methodInsnNode = (MethodInsnNode)next).getOpcode() != 184 || !methodInsnNode.owner.equals("com/google/common/collect/Maps") || !methodInsnNode.name.equals("newHashMap") || !methodInsnNode.desc.equals("(Ljava/util/Map;)Ljava/util/HashMap;")) continue;
                        iterator.set(new MethodInsnNode(184, Type.getInternalName(ASMTransformerNbtOpsMapBuilderFastUtilMap.class), "newFastUtilMap", Type.getMethodDescriptor((Method)ASMTransformerNbtOpsMapBuilderFastUtilMap.class.getMethod("newFastUtilMap", Map.class))));
                        patched = true;
                    }
                    if (patched) continue;
                    LOGGER.warn("Unable to find target opcode in NbtOps$MapBuilder");
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <K, V> Map<K, V> newFastUtilMap(Map<K, V> map) {
        return new Object2ObjectOpenHashMap(map);
    }
}

