/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.feature;

import com.aetherteam.aether.world.configuration.AetherLakeConfiguration;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class AetherLakeFeature
extends Feature<AetherLakeConfiguration> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public AetherLakeFeature(Codec<AetherLakeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<AetherLakeConfiguration> context) {
        int i2;
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        AetherLakeConfiguration aetherLakeConfiguration = (AetherLakeConfiguration)context.m_159778_();
        if (blockPos.m_123342_() <= level.m_141937_() + 4) {
            return false;
        }
        blockPos = blockPos.m_6625_(4);
        boolean[] booleans = new boolean[2048];
        int i = random.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.m_188500_() * 6.0 + 3.0;
            double d1 = random.m_188500_() * 4.0 + 2.0;
            double d2 = random.m_188500_() * 6.0 + 3.0;
            double d3 = random.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        booleans[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState fluidBlockState = aetherLakeConfiguration.fluid().m_213972_(random, blockPos);
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int k = 0; k < 16; ++k) {
                for (int l2 = 0; l2 < 8; ++l2) {
                    boolean flag;
                    boolean bl = flag = !booleans[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && booleans[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && booleans[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && booleans[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && booleans[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && booleans[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && booleans[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (!flag) continue;
                    BlockState offsetState = level.m_8055_(blockPos.m_7918_(k1, l2, k));
                    if (l2 >= 4 && offsetState.m_278721_()) {
                        return false;
                    }
                    if (l2 >= 4 || offsetState.m_280296_() || level.m_8055_(blockPos.m_7918_(k1, l2, k)) == fluidBlockState) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    BlockPos offsetPos;
                    if (!booleans[(l1 * 16 + i2) * 8 + i3] || !this.canReplaceBlock(level.m_8055_(offsetPos = blockPos.m_7918_(l1, i3, i2)))) continue;
                    boolean flag1 = i3 >= 4;
                    level.m_7731_(offsetPos, flag1 ? AIR : fluidBlockState, 2);
                    if (!flag1) continue;
                    level.m_186460_(offsetPos, AIR.m_60734_(), 0);
                    this.m_159739_(level, offsetPos);
                }
            }
        }
        BlockState topBlockState = aetherLakeConfiguration.top().m_213972_(random, blockPos);
        if (!topBlockState.m_60795_()) {
            for (i2 = 0; i2 < 16; ++i2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    for (int j4 = 4; j4 < 8; ++j4) {
                        BlockPos offsetPos;
                        if (!booleans[(i2 * 16 + j3) * 8 + j4] || !AetherLakeFeature.m_159759_((BlockState)level.m_8055_(offsetPos = blockPos.m_7918_(i2, j4 - 1, j3))) || level.m_45517_(LightLayer.SKY, blockPos.m_7918_(i2, j4, j3)) <= 0) continue;
                        level.m_7731_(offsetPos, topBlockState, 2);
                    }
                }
            }
        }
        if (fluidBlockState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int k3 = 0; k3 < 16; ++k3) {
                    BlockPos offsetPos = blockPos.m_7918_(k2, 4, k3);
                    if (!((Biome)level.m_204166_(offsetPos).m_203334_()).m_47480_((LevelReader)level, offsetPos, false) || !this.canReplaceBlock(level.m_8055_(offsetPos))) continue;
                    level.m_7731_(offsetPos, Blocks.f_50126_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.m_204336_(BlockTags.f_144287_);
    }
}

