/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.items;

import codyhuh.ambientadditions.AmbientAdditions;
import codyhuh.ambientadditions.common.block_entities.CrateBlockEntity;
import codyhuh.ambientadditions.common.blocks.CrateBlock;
import codyhuh.ambientadditions.data.SedationData;
import codyhuh.ambientadditions.data.SedationProvider;
import codyhuh.ambientadditions.registry.AABlocks;
import codyhuh.ambientadditions.registry.AATags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;

public class CrateItem
extends BlockItem {
    public static final String DATA_CREATURE = "CreatureData";

    public CrateItem(Item.Properties properties) {
        super((Block)AABlocks.CRATE.get(), properties);
    }

    public int getMaxStackSize(ItemStack stack) {
        return CrateItem.containsEntity(stack) ? 1 : super.getMaxStackSize(stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        LazyOptional cap;
        int sedationLevel;
        Level level = player.m_9236_();
        if (CrateItem.containsEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (!target.m_20197_().isEmpty()) {
            target.m_20153_();
        }
        int n = sedationLevel = (cap = target.getCapability(SedationProvider.SEDATION_CAP)).resolve().isPresent() ? ((SedationData)cap.resolve().get()).getLevel() : 0;
        if (this.canBeCrated(target) && target.getPersistentData().m_128471_("IsSedated") && sedationLevel >= AmbientAdditions.sedationLvlRequiredToCapture(target.m_21233_())) {
            return this.successfulCrate(player, target, stack, level);
        }
        return InteractionResult.m_19078_((boolean)true);
    }

    public InteractionResult successfulCrate(Player player, LivingEntity target, ItemStack stack, Level level) {
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        CompoundTag targetTag = target.serializeNBT();
        target.m_146870_();
        BlockPos pos = target.m_20183_();
        level.m_151523_((BlockEntity)new CrateBlockEntity(pos, (BlockState)((Block)AABlocks.CRATE.get()).m_49966_().m_61124_((Property)CrateBlock.FULL, (Comparable)Boolean.valueOf(true))));
        level.m_7731_(pos, (BlockState)((Block)AABlocks.CRATE.get()).m_49966_().m_61124_((Property)CrateBlock.FULL, (Comparable)Boolean.valueOf(true)), 3);
        level.m_5594_(null, pos, SoundEvents.f_11724_, SoundSource.PLAYERS, 1.0f, 1.0f);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity crate = (CrateBlockEntity)blockEntity;
            crate.setCreatureData(targetTag, crate.getPersistentData());
        }
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double d0 = 0.5;
            double d1 = ((Block)AABlocks.CRATE.get()).m_49966_().m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            double d2 = level.f_46441_.m_188583_() * 0.02;
            double d3 = level.f_46441_.m_188583_() * 0.02;
            double d4 = level.f_46441_.m_188583_() * 0.02;
            double d6 = (double)pos.m_123341_() + level.f_46441_.m_188500_() * d0 * 2.0;
            double d7 = (double)pos.m_123342_() + level.f_46441_.m_188500_() * d1;
            double d8 = (double)pos.m_123343_() + level.f_46441_.m_188500_() * d0 * 2.0;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, d6, d7, d8, 100, d2, d3, d4, 0.1);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult unsuccessfulCrate(LivingEntity target, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos pos = target.m_20183_();
            double d0 = 0.5;
            double d1 = ((Block)AABlocks.CRATE.get()).m_49966_().m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            double d2 = level.f_46441_.m_188583_() * 0.02;
            double d3 = level.f_46441_.m_188583_() * 0.02;
            double d4 = level.f_46441_.m_188583_() * 0.02;
            double d6 = (double)pos.m_123341_() + level.f_46441_.m_188500_() * d0 * 2.0;
            double d7 = (double)pos.m_123342_() + level.f_46441_.m_188500_() * d1;
            double d8 = (double)pos.m_123343_() + level.f_46441_.m_188500_() * d0 * 2.0;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d6, d7, d8, 100, d2, d3, d4, 0.1);
        }
        return InteractionResult.PASS;
    }

    private boolean canBeCrated(LivingEntity entity) {
        return !entity.m_6095_().m_204039_(AATags.UNCRATEABLE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult rt = CrateItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        ItemStack stack = player.m_21120_(hand);
        if (rt.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = rt.m_82425_();
        if (!(level.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent name = (MutableComponent)super.m_7626_(stack);
        MutableComponent creatureName = CrateItem.containsEntity(stack) ? ((EntityType)EntityType.m_20632_((String)stack.m_41783_().m_128469_(DATA_CREATURE).m_128461_("id")).orElse(null)).m_20676_().m_6881_() : Component.m_237119_();
        return CrateItem.containsEntity(stack) ? name.m_6881_().m_130946_(" of ").m_7220_((Component)creatureName) : name;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (CrateItem.containsEntity(stack)) {
            CompoundTag tag = stack.m_41783_().m_128469_(DATA_CREATURE);
            MutableComponent name = tag.m_128441_("CustomName") ? Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}) : ((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_20676_().m_6881_().m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)name);
            String entity = EntityType.m_20613_((EntityType)EntityType.m_20632_((String)tag.m_128461_("id")).orElse(null)).m_135815_();
            MutableComponent extraInfo = Component.m_237115_((String)("tooltip.ambientadditions.fun_fact." + entity)).m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC});
            if (Screen.m_96638_() && !extraInfo.getString().equals("tooltip.ambientadditions.fun_fact." + entity)) {
                tooltip.add((Component)extraInfo);
            }
        }
    }

    public static boolean containsEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(DATA_CREATURE);
    }
}

