/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities.ai.goal;

import codyhuh.ambientadditions.common.entities.FlyingFish;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class FlyingFishJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final FlyingFish fish;
    private final int interval;
    private boolean breached;

    public FlyingFishJumpGoal(FlyingFish p_i50329_1_, int p_i50329_2_) {
        this.fish = p_i50329_1_;
        this.interval = p_i50329_2_;
    }

    public boolean m_8036_() {
        if (this.fish.m_217043_().m_188503_(this.interval) != 0) {
            return false;
        }
        Direction direction = this.fish.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.fish.m_20183_();
        for (int k : STEPS_TO_CHECK) {
            if (this.waterIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos p_220709_1_, int p_220709_2_, int p_220709_3_, int p_220709_4_) {
        BlockPos blockpos = p_220709_1_.m_7918_(p_220709_2_ * p_220709_4_, 0, p_220709_3_ * p_220709_4_);
        return this.fish.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.fish.m_9236_().m_8055_(blockpos).m_280555_();
    }

    private boolean surfaceIsClear(BlockPos p_220708_1_, int p_220708_2_, int p_220708_3_, int p_220708_4_) {
        return this.fish.m_9236_().m_8055_(p_220708_1_.m_7918_(p_220708_2_ * p_220708_4_, 1, p_220708_3_ * p_220708_4_)).m_60795_() && this.fish.m_9236_().m_8055_(p_220708_1_.m_7918_(p_220708_2_ * p_220708_4_, 2, p_220708_3_ * p_220708_4_)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.fish.m_20184_().f_82480_;
        return !(d0 * d0 < (double)0.03f && this.fish.m_146909_() != 0.0f && Math.abs(this.fish.m_146909_()) < 10.0f && this.fish.m_20069_() || this.fish.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.fish.m_6374_();
        this.fish.m_20256_(this.fish.m_20184_().m_82520_((double)direction.m_122429_() * 2.0, 1.0, (double)direction.m_122431_() * 2.0));
        this.fish.m_20256_(this.fish.m_20184_().m_82542_(2.0, 1.0, 2.0));
        this.fish.m_21573_().m_26573_();
        this.fish.setFlying(true);
    }

    public void m_8041_() {
        this.fish.m_146926_(0.0f);
        this.fish.setFlying(false);
    }

    public void m_8037_() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.fish.m_9236_().m_6425_(this.fish.m_20183_());
            this.breached = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        if (this.breached && !flag) {
            this.fish.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
        }
        Vec3 vector3d = this.fish.m_20184_();
        if (vector3d.f_82480_ * vector3d.f_82480_ < (double)0.03f && this.fish.m_146909_() != 0.0f) {
            this.fish.m_146926_(Mth.m_14189_((float)this.fish.m_146909_(), (float)0.0f, (float)0.2f));
        } else {
            double d0 = vector3d.m_165925_();
            double d1 = Math.signum(-vector3d.f_82480_) * Math.acos(d0 / vector3d.m_82553_()) * 57.2957763671875;
            this.fish.m_146926_((float)d1);
        }
    }
}

