/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.ai.goal.BatFlyWanderGoal;
import codyhuh.ambientadditions.common.entities.ai.goal.BatLandOnGroundGoal;
import codyhuh.ambientadditions.common.entities.ai.goal.BatMoveToLeavesGoal;
import codyhuh.ambientadditions.common.entities.ai.movement.GroundAndFlyingMoveControl;
import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.registry.AAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WhiteFruitBat
extends Animal
implements FlyingAnimal,
GeoEntity {
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(WhiteFruitBat.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_FLYING = SynchedEntityData.m_135353_(WhiteFruitBat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LANDING = SynchedEntityData.m_135353_(WhiteFruitBat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FLIGHT_TICKS = SynchedEntityData.m_135353_(WhiteFruitBat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public BatFlyWanderGoal wanderGoal;
    public BatLandOnGroundGoal landGoal;
    public float prevTilt;
    public float tilt;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public WhiteFruitBat(EntityType<? extends WhiteFruitBat> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new GroundAndFlyingMoveControl(this, 60, 12000);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.025).m_22268_(Attributes.f_22280_, 0.15);
    }

    protected void m_8099_() {
        this.landGoal = new BatLandOnGroundGoal(this, 1.0);
        this.wanderGoal = new BatFlyWanderGoal(this, 4.0, 0.01f);
        this.f_21345_.m_25352_(0, (Goal)this.wanderGoal);
        this.f_21345_.m_25352_(0, (Goal)new BatMoveToLeavesGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)this.landGoal);
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7023_(Vec3 vec3d) {
        boolean flying = this.m_29443_();
        float speed = (float)this.m_21133_(flying ? Attributes.f_22280_ : Attributes.f_22279_);
        if (this.isResting()) {
            vec3d = Vec3.f_82478_;
            super.m_7023_(vec3d);
            return;
        }
        if (flying) {
            this.m_19920_(speed, vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            this.m_267651_(true);
        } else {
            super.m_7023_(vec3d);
        }
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    public boolean wantsToFly() {
        return this.canFly() && this.getFlightTicks() <= 12000;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.WHITE_FRUIT_BAT_SPAWN_EGG.get());
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return true;
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(false);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected SoundEvent m_7515_() {
        return this.isResting() && this.f_19796_.m_188503_(4) != 0 ? null : SoundEvents.f_11731_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11733_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11732_;
    }

    protected float m_6121_() {
        return 0.05f;
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.3f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(FLIGHT_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_LANDING, (Object)false);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_82167_1_) {
    }

    protected void m_6138_() {
    }

    public boolean isResting() {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean p_82236_1_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (p_82236_1_) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)pCompound.m_128445_("BatFlags"));
        this.setFlying(pCompound.m_128471_("IsBatFlying"));
        this.setFlightTicks(pCompound.m_128451_("FlightTicks"));
        this.setLanding(pCompound.m_128471_("IsLanding"));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128344_("BatFlags", ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS)).byteValue());
        pCompound.m_128379_("IsBatFlying", this.m_29443_());
        pCompound.m_128405_("FlightTicks", this.getFlightTicks());
        pCompound.m_128379_("IsLanding", this.isLanding());
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(IS_FLYING, (Object)flying);
    }

    public boolean isLanding() {
        return (Boolean)this.f_19804_.m_135370_(IS_LANDING);
    }

    public void setLanding(boolean landing) {
        this.f_19804_.m_135381_(IS_LANDING, (Object)landing);
    }

    public int getFlightTicks() {
        return (Integer)this.f_19804_.m_135370_(FLIGHT_TICKS);
    }

    public void setFlightTicks(int flightTicks) {
        this.f_19804_.m_135381_(FLIGHT_TICKS, (Object)flightTicks);
    }

    public boolean canFly() {
        BlockPos pos = this.m_20183_();
        return !this.m_9236_().m_8055_(pos.m_7495_()).m_280296_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().f_46443_ && this.isResting()) {
            this.setResting(false);
        }
        if (this.wanderGoal != null) {
            this.wanderGoal.m_25751_();
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_20242_(boolean pNoGravity) {
        super.m_20242_(this.m_29443_() || this.isLanding());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(1)).m_60795_() && !this.m_29443_() && !this.isLanding() && this.landGoal != null) {
            this.landGoal.m_25751_();
        }
        if (this.getFlightTicks() <= 12000 && (this.m_29443_() || this.isLanding()) && !this.m_21525_()) {
            this.setFlightTicks(this.getFlightTicks() + 1);
        }
        if (this.m_20096_() || this.getFlightTicks() >= 12000 || this.m_5842_()) {
            this.setFlying(false);
        }
        if (this.m_20096_() && this.isLanding()) {
            this.setLanding(false);
        }
        if (this.getFlightTicks() > 0 && !this.m_29443_()) {
            this.setFlightTicks(this.getFlightTicks() - 1);
        }
        double x = this.m_20184_().m_7096_();
        double z = this.m_20184_().m_7094_();
        if (this.wanderGoal != null && this.wantsToFly()) {
            this.wanderGoal.m_25751_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevTilt = this.tilt;
        if (!this.m_20096_()) {
            float v = Mth.m_14118_((float)this.m_146908_(), (float)this.f_19859_);
            if (Math.abs(v) > 1.0f) {
                if (Math.abs(this.tilt) < 25.0f) {
                    this.tilt += Math.signum(v);
                }
            } else if (Math.abs(this.tilt) > 0.0f) {
                float tiltSign = Math.signum(this.tilt);
                this.tilt -= tiltSign * 3.0f;
                if (this.tilt * tiltSign < 0.0f) {
                    this.tilt = 0.0f;
                }
            }
        } else {
            this.tilt = 0.0f;
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_20183_();
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.m_9236_().m_8055_(blockpos1).m_60795_() && this.m_9236_().m_6425_(blockpos1).m_76178_()) {
            this.setResting(true);
        } else if (this.isResting()) {
            boolean flag = this.m_20067_();
            if (!this.m_9236_().m_8055_(blockpos1).m_60795_() || this.getPersistentData().m_128471_("IsSedated")) {
                if (this.f_19796_.m_188503_(200) == 0) {
                    this.f_20885_ = this.f_19796_.m_188503_(360);
                }
            } else {
                this.setResting(false);
                if (!flag) {
                    this.m_9236_().m_5898_(null, 1025, blockpos, 0);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (event.isMoving()) {
            event.setAnimation(AAAnimations.FLY);
            event.getController().setAnimationSpeed(2.0);
        } else {
            event.setAnimation(AAAnimations.SIT);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

