/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.registry.AAEntities;
import codyhuh.ambientadditions.registry.AAItems;
import codyhuh.ambientadditions.registry.AASounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PembrokeCorgi
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(PembrokeCorgi.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PembrokeCorgi(EntityType<? extends PembrokeCorgi> p_i50240_1_, Level p_i50240_2_) {
        super(p_i50240_1_, p_i50240_2_);
        this.m_7105_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)p_70037_1_.m_128451_("CollarColor")));
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AASounds.CORGI_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.2f;
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return p_213348_2_.f_20378_ * 0.8f;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        Entity entity = p_70097_1_.m_7639_();
        this.m_21839_(false);
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_70097_2_ = (p_70097_2_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    public void m_7105_(boolean p_70903_1_) {
        super.m_7105_(p_70903_1_);
        if (p_70903_1_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)p_230254_1_) || this.m_21824_() || item == Items.f_42500_ && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!p_230254_1_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(item.m_41473_().m_38744_());
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult actionresulttype = super.m_6071_(p_230254_1_, p_230254_2_);
                if ((!actionresulttype.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)p_230254_1_)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    return InteractionResult.SUCCESS;
                }
                return actionresulttype;
            }
            DyeColor dyecolor = ((DyeItem)item).m_41089_();
            if (dyecolor != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                if (!p_230254_1_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (item == Items.f_42687_) {
            if (!p_230254_1_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_230254_1_)) {
                this.m_21828_(p_230254_1_);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public boolean m_6898_(ItemStack p_70877_1_) {
        Item item = p_70877_1_.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_175547_1_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_175547_1_.m_41060_());
    }

    public PembrokeCorgi getBreedOffspring(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        PembrokeCorgi corgi = (PembrokeCorgi)((EntityType)AAEntities.PEMBROKE_CORGI.get()).m_20615_((Level)p_241840_1_);
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            corgi.m_21816_(uuid);
            corgi.m_7105_(true);
        }
        return corgi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.PEMBROKE_CORGI_SPAWN_EGG.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        if (this.m_21825_()) {
            event.setAnimation(AAAnimations.SIT);
            event.getController().setAnimationSpeed(1.0);
        } else if (event.isMoving()) {
            event.setAnimation(AAAnimations.WALK);
            event.getController().setAnimationSpeed(2.5);
        } else {
            event.setAnimation(AAAnimations.IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

