/*
 * Decompiled with CFR 0.152.
 */
package codyhuh.ambientadditions.common.entities;

import codyhuh.ambientadditions.common.entities.ChocolateChipStarfish;
import codyhuh.ambientadditions.common.entities.ai.goal.AvoidEntityWithoutMaskGoal;
import codyhuh.ambientadditions.common.entities.util.AAAnimations;
import codyhuh.ambientadditions.common.entities.util.NonSwimmer;
import codyhuh.ambientadditions.registry.AAItems;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HarlequinShrimp
extends NonSwimmer
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(HarlequinShrimp.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(HarlequinShrimp.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public HarlequinShrimp(EntityType<? extends NonSwimmer> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, new AvoidEntityWithoutMaskGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 1.2, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.15, true){

            public boolean m_8036_() {
                return super.m_8036_();
            }

            public void m_8037_() {
                if (HarlequinShrimp.this.m_5448_() != null && (double)HarlequinShrimp.this.m_5448_().m_21223_() < 5.0) {
                    this.m_8041_();
                }
                super.m_8037_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<ChocolateChipStarfish>((Mob)this, ChocolateChipStarfish.class, false){

            public boolean m_8045_() {
                return super.m_8045_() && this.f_26050_ != null && (double)this.f_26050_.m_21223_() > 4.0;
            }
        });
    }

    public int m_5792_() {
        return 1;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected ItemStack getFishBucket() {
        return new ItemStack((ItemLike)AAItems.HARLEQUIN_SHRIMP_BUCKET.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12529_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)AAItems.HARLEQUIN_SHRIMP_SPAWN_EGG.get());
    }

    public boolean m_8023_() {
        return !this.isFromBucket();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    private boolean isFromBucket() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void setFromBucket(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_203706_1_);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    private void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.isFromBucket());
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFromBucket(compound.m_128471_("FromBucket"));
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag != null && dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
        } else {
            this.setVariant(this.f_19796_.m_188503_(3));
        }
        return spawnDataIn;
    }

    protected InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (itemstack.m_41720_() == Items.f_42447_ && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack itemstack1 = this.getFishBucket();
            this.setBucketData(itemstack1);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)p_230254_1_, itemstack1);
            }
            if (itemstack.m_41619_()) {
                p_230254_1_.m_21008_(p_230254_2_, itemstack1);
            } else if (!p_230254_1_.m_150109_().m_36054_(itemstack1)) {
                p_230254_1_.m_36176_(itemstack1, false);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128405_("Variant", this.getVariant());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <E extends GeoEntity> PlayState predicate(AnimationState<E> event) {
        boolean walking;
        boolean bl = walking = !(event.getLimbSwingAmount() > -0.01f) || !(event.getLimbSwingAmount() < 0.01f);
        if (walking) {
            event.setAnimation(AAAnimations.WALK);
            event.getController().setAnimationSpeed(2.5);
        } else {
            event.setAnimation(AAAnimations.IDLE);
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

