/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.chunkio.mixin.limit_nbt_cache;

import com.ishland.c2me.opts.chunkio.common.Config;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IOWorker.class}, priority=990)
public abstract class MixinStorageIoWorker {
    @Shadow
    @Final
    private Map<ChunkPos, IOWorker.PendingStore> f_63519_;
    @Shadow
    @Final
    private static Logger f_63515_;

    @Shadow
    protected abstract void m_63535_(ChunkPos var1, IOWorker.PendingStore var2);

    @Shadow
    protected abstract void m_63561_();

    @Inject(method={"method_27939"}, at={@At(value="HEAD")})
    private void preTask(CallbackInfo ci) {
        this.checkHardLimit();
    }

    @Inject(method={"writeResult"}, at={@At(value="HEAD")})
    private void onWriteResult(CallbackInfo ci) {
        if (!this.f_63519_.isEmpty()) {
            this.checkHardLimit();
            if ((long)this.f_63519_.size() >= Config.chunkDataCacheSoftLimit) {
                int writeFrequency = Math.min(1, (this.f_63519_.size() - (int)Config.chunkDataCacheSoftLimit) / 16);
                for (int i = 0; i < writeFrequency; ++i) {
                    this.writeResult0();
                }
            }
        }
    }

    @Unique
    private void checkHardLimit() {
        if ((long)this.f_63519_.size() >= Config.chunkDataCacheLimit) {
            f_63515_.warn("Chunk data cache size exceeded hard limit ({} >= {}), forcing writes to disk (you can increase chunkDataCacheLimit in c2me.toml)", (Object)this.f_63519_.size(), (Object)Config.chunkDataCacheLimit);
            while ((double)this.f_63519_.size() >= (double)Config.chunkDataCacheSoftLimit * 0.75) {
                this.writeResult0();
            }
        }
    }

    @Unique
    private void writeResult0() {
        Iterator<Map.Entry<ChunkPos, IOWorker.PendingStore>> iterator = this.f_63519_.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ChunkPos, IOWorker.PendingStore> entry = iterator.next();
            iterator.remove();
            this.m_63535_(entry.getKey(), entry.getValue());
        }
    }
}

