/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.gui;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.font.TextFieldHelper;
import org.jetbrains.annotations.Nullable;

public class StyledTextFieldHelper
extends TextFieldHelper {
    private static final char TOKEN = '\u00a7';
    private final Supplier<String> getMessageFn;

    public StyledTextFieldHelper(Supplier<String> supplier, Consumer<String> consumer, Supplier<String> supplier2, Consumer<String> consumer2, Predicate<String> predicate) {
        super(supplier, consumer, supplier2, consumer2, predicate);
        this.getMessageFn = supplier;
    }

    public void m_232572_(int direction, TextFieldHelper.CursorStep cursorStep) {
        boolean hasTokenAtCursor;
        String msg = this.getMessageFn.get();
        int cursorPos = this.m_95194_();
        boolean bl = hasTokenAtCursor = cursorPos < msg.length() && msg.charAt(cursorPos) == '\u00a7';
        if (direction < 0) {
            int k = StyledTextFieldHelper.getIndexBeforeToken(direction, msg, cursorPos);
            if (cursorPos == msg.length() || hasTokenAtCursor) {
                direction = k;
            }
            super.m_232572_(direction, cursorStep);
            if (k != direction) {
                this.m_232575_(k + 1, false, cursorStep);
            }
        } else if (hasTokenAtCursor) {
            this.m_232575_(direction, false, TextFieldHelper.CursorStep.CHARACTER);
            this.m_232572_(-1, cursorStep);
        } else {
            super.m_232572_(direction, cursorStep);
        }
    }

    private static int getIndexBeforeToken(int i, String msg, int cursorPos) {
        int p = cursorPos - 3;
        if (p >= 0 && msg.length() > p && msg.charAt(p) == '\u00a7') {
            i = -3;
            int p1 = cursorPos - 5;
            if (p1 >= 0 && msg.charAt(p1) == '\u00a7') {
                i = -5;
            }
        }
        return i;
    }

    public void m_232575_(int i, boolean keepSelection, TextFieldHelper.CursorStep cursorStep) {
        String msg = this.getMessageFn.get();
        int cursorPos = this.m_95194_();
        if (i < 0) {
            i = StyledTextFieldHelper.getIndexBeforeToken(i, msg, cursorPos);
            super.m_232575_(i, keepSelection, cursorStep);
        } else {
            if (cursorPos < msg.length() && msg.charAt(cursorPos) == '\u00a7') {
                i = 3;
                int p = cursorPos + 2;
                if (p < msg.length() && msg.charAt(p) == '\u00a7') {
                    i = 5;
                }
            }
            super.m_232575_(i, keepSelection, TextFieldHelper.CursorStep.CHARACTER);
        }
    }

    public void insertStyledText(String text, ChatFormatting color, ChatFormatting style) {
        String lastMod;
        String currentMod = this.getModifier(color, style);
        if (!Objects.equals(currentMod, lastMod = this.getPreviousModifier())) {
            String s = currentMod + text;
            this.m_95158_(s);
            int j = this.m_95194_();
            if (this.m_95194_() != this.getMessageFn.get().length() && lastMod != null) {
                this.m_95158_(lastMod);
                super.m_95179_(j, false);
            }
        } else {
            this.m_95158_(text);
        }
    }

    public void m_95179_(int textIndex, boolean keepSelection) {
        String text = this.getMessageFn.get();
        super.m_95179_(textIndex, keepSelection);
    }

    private String getModifier(ChatFormatting color, ChatFormatting style) {
        Object s = color.toString();
        if (style != ChatFormatting.RESET) {
            s = (String)s + style.toString();
        }
        return ((String)s).replace('\u00a7', '\u00a7');
    }

    @Nullable
    private String getPreviousModifier() {
        int cursorPos;
        String text = this.getMessageFn.get();
        for (int i = cursorPos = this.m_95194_() - 1; i >= 0 && i < text.length(); --i) {
            if (text.charAt(i) != '\u00a7') continue;
            int start = i;
            int end = i + 2;
            if (i >= 2 && text.charAt(i - 2) == '\u00a7') {
                start -= 2;
            }
            if (end > text.length()) continue;
            return text.substring(start, end);
        }
        return null;
    }

    public void formatSelected(@Nullable ChatFormatting ink, @Nullable ChatFormatting quill) {
    }
}

