/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.util;

import java.util.List;
import net.minecraft.util.RandomSource;

public record BSColor(int a, int r, int g, int b) {
    public static BSColor of(int a, int r, int g, int b) {
        return new BSColor(a, r, g, b);
    }

    public int asNum() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public static BSColor fromIntList(List<Integer> integerList) {
        return BSColor.of(255, integerList.get(0), integerList.get(1), integerList.get(2));
    }

    public BSColor randomize(int scaleR, int scaleG, int scaleB, RandomSource rand) {
        int red = Math.min(this.r - scaleR + (int)(rand.m_188583_() * (double)scaleR), 255);
        int green = Math.min(this.g - scaleG + (int)(rand.m_188583_() * (double)scaleG), 255);
        int blue = Math.min(this.b - scaleB + (int)(rand.m_188583_() * (double)scaleB), 255);
        return new BSColor(this.a, red, green, blue);
    }

    public BSColor randomize(int scale, RandomSource rand) {
        return this.randomize(scale, scale, scale, rand);
    }

    public BSColor shade(float factor) {
        if (factor < 0.0f || factor > 1.0f) {
            throw new IllegalArgumentException("Factor must be between 0 and 1.");
        }
        return new BSColor(this.a, (int)((float)this.r * factor), (int)((float)this.g * factor), (int)((float)this.b * factor));
    }

    public BSColor shadeWithBlueShift(float factor, float blueShiftIntensity) {
        if (factor < 0.0f || factor > 1.0f || blueShiftIntensity < 0.0f || blueShiftIntensity > 1.0f) {
            throw new IllegalArgumentException("Factor and blueShiftIntensity must be between 0 and 1.");
        }
        int shiftedRed = (int)((float)this.r * factor * (1.0f - blueShiftIntensity));
        int shiftedGreen = (int)((float)this.g * factor * (1.0f - blueShiftIntensity / 2.0f));
        int shiftedBlue = (int)Math.min((float)this.b * factor + (255.0f - (float)this.b * factor) * blueShiftIntensity, 255.0f);
        return new BSColor(this.a, shiftedRed, shiftedGreen, shiftedBlue);
    }
}

