/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.triggers;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.aqutheseal.blessfulled.particle.DamagePopupParticleData;
import org.aqutheseal.blessfulled.util.mixinhelper.CritTracker;

@Mod.EventBusSubscriber(modid="blessfulled", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamagePopupTriggers {
    public static void triggerEffect(Entity source, Entity target, float amount, int popupType) {
        Level level;
        if (source instanceof Player && (level = target.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Vec3 pos = target.m_146892_();
            server.m_8767_((ParticleOptions)new DamagePopupParticleData(amount, popupType), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        ((CritTracker)target).blessfulled$disableHasCritted();
    }

    public static void healTrigger(LivingEntity target, float amount) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!(target instanceof Player)) {
                Vec3 pos = target.m_146892_();
                server.m_8767_((ParticleOptions)new DamagePopupParticleData(amount, 2), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void hurtTrigger(LivingEntity target, DamageSource source, float damage) {
        Entity attacker = source.m_7639_();
        if (source.m_276093_(DamageTypes.f_268464_)) {
            DamagePopupTriggers.triggerEffect(attacker, (Entity)target, damage, ((CritTracker)target).blessfulled$hasCritted() ? 1 : 0);
            return;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            DamagePopupTriggers.triggerEffect(attacker, (Entity)target, damage, 4);
            return;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            DamagePopupTriggers.triggerEffect(attacker, (Entity)target, damage, arrow.m_36792_() ? 4 : 6);
            return;
        }
        if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268530_)) {
            DamagePopupTriggers.triggerEffect(attacker, (Entity)target, damage, 5);
            return;
        }
        DamagePopupTriggers.triggerEffect(attacker, (Entity)target, damage, 6);
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Entity entity;
        if (event.isVanillaCritical() && (entity = event.getTarget()) instanceof CritTracker) {
            CritTracker tracker = (CritTracker)entity;
            tracker.blessfulled$enableHasCritted();
        }
    }
}

