/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.aqutheseal.blessfulled.registry.BSParticles;
import org.jetbrains.annotations.NotNull;

public record DamagePopupParticleData(float damage, int popupType) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<DamagePopupParticleData> DESERIALIZER = new ParticleOptions.Deserializer<DamagePopupParticleData>(){

        @NotNull
        public DamagePopupParticleData fromCommand(@NotNull ParticleType<DamagePopupParticleData> pParticleType, StringReader pReader) throws CommandSyntaxException {
            pReader.expect(' ');
            float f = pReader.readFloat();
            pReader.expect(' ');
            int i = pReader.readInt();
            return new DamagePopupParticleData(f, i);
        }

        @NotNull
        public DamagePopupParticleData fromNetwork(@NotNull ParticleType<DamagePopupParticleData> pParticleType, FriendlyByteBuf pBuffer) {
            return new DamagePopupParticleData(pBuffer.readFloat(), pBuffer.readInt());
        }
    };
    public static final Codec<DamagePopupParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("damage").forGetter(options -> Float.valueOf(options.damage)), (App)Codec.INT.fieldOf("popupType").forGetter(options -> options.popupType)).apply((Applicative)instance, DamagePopupParticleData::new));

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %d", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.damage), this.popupType);
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        pBuffer.writeFloat(this.damage);
        pBuffer.writeInt(this.popupType);
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)BSParticles.DAMAGE_POPUP.get();
    }
}

