/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.aqutheseal.blessfulled.BSClientConfig;
import org.aqutheseal.blessfulled.particle.DamagePopupParticleData;
import org.aqutheseal.blessfulled.util.BSColor;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DamagePopupParticle
extends TextureSheetParticle {
    public static final int TYPE_MELEE = 0;
    public static final int TYPE_CRIT_MELEE = 1;
    public static final int TYPE_HEAL = 2;
    public static final int TYPE_CRIT_PROJECTILE = 4;
    public static final int TYPE_MAGIC = 5;
    public static final int TYPE_MISC = 6;
    private static final ParticleGroup GROUP = new ParticleGroup(1000);
    public final float damage;
    public final int popupType;
    public final String onomatopoeia;
    public final BSColor uniqueColor;
    public final boolean shouldScale;
    public final double xf;
    public final double yf;
    public final double zf;

    protected DamagePopupParticle(ClientLevel pLevel, double pX, double pY, double pZ, float damage, int popupType) {
        super(pLevel, pX, pY, pZ);
        RandomSource rand = pLevel.f_46441_;
        this.damage = damage;
        this.popupType = popupType;
        this.onomatopoeia = switch (popupType) {
            case 0 -> BSClientConfig.meleeExpressions.get(rand.m_188503_(BSClientConfig.meleeExpressions.size()));
            case 1 -> BSClientConfig.critMeleeExpressions.get(rand.m_188503_(BSClientConfig.critMeleeExpressions.size()));
            case 4 -> BSClientConfig.critArrowExpressions.get(rand.m_188503_(BSClientConfig.critArrowExpressions.size()));
            default -> "";
        };
        BSColor genericColor = BSClientConfig.genericColor;
        this.uniqueColor = switch (popupType) {
            case 1, 4 -> BSClientConfig.criticalColor;
            case 2 -> BSClientConfig.healColor;
            case 5 -> BSClientConfig.magicHitColor;
            default -> new BSColor(255, genericColor.r(), Math.max(0, genericColor.g() - (int)damage), Math.max(0, genericColor.b() - (int)damage));
        };
        this.shouldScale = this.popupType == 1 || this.popupType == 4;
        this.f_107225_ = this.shouldScale ? 30 : 20;
        this.f_107226_ = 0.0f;
        this.f_107212_ += rand.m_188583_() * 0.5;
        this.f_107213_ += rand.m_188583_() * 0.5;
        this.f_107214_ += rand.m_188583_() * 0.5;
        this.xf = this.f_107212_;
        this.yf = this.f_107213_;
        this.zf = this.f_107214_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        double[] midpoint = DamagePopupParticle.calculateMidpoint(player.m_20185_(), player.m_20188_(), player.m_20189_(), this.xf, this.yf, this.zf);
        this.f_107663_ = 1.0f + (float)DamagePopupParticle.calculateDistance(player.m_20185_(), player.m_20188_(), player.m_20189_(), this.f_107212_, this.f_107213_, this.f_107214_) * 0.05f;
        this.f_107212_ = midpoint[0];
        this.f_107213_ = midpoint[1];
        this.f_107214_ = midpoint[2];
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Vec3 posVec = pRenderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_) - posVec.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_) - posVec.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_) - posVec.m_7094_());
        if (BSClientConfig.showExpression) {
            this.renderCounter(f, f1, f2, pRenderInfo, font, minecraft, pPartialTicks);
        }
        if (BSClientConfig.showDamage) {
            this.renderText(f, f1, f2, pRenderInfo, font, minecraft, pPartialTicks);
        }
        minecraft.m_91269_().m_110104_().m_109911_();
    }

    public void renderText(float pvX, float pvY, float pvZ, Camera pRenderInfo, Font font, Minecraft mc, float pPartialTicks) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate(pvX, pvY, pvZ);
        matrix.rotate((Quaternionfc)pRenderInfo.m_253121_());
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        float scale = DamagePopupParticle.easeOut((float)this.f_107224_ + pPartialTicks, 0.0f, 0.001f, this.f_107225_ - 5, (float)(this.shouldScale ? 150 : 100) * this.f_107663_ * (float)BSClientConfig.popupSizeMultiplier);
        matrix.scale(-scale, -scale, scale);
        if (this.f_107224_ <= this.f_107225_ - 5) {
            MutableComponent text2 = Component.m_237113_((String)this.onomatopoeia);
            BSColor color = new BSColor(255, 255, 255, 255);
            if (BSClientConfig.showOutline) {
                font.m_168645_(text2.m_7532_(), (float)(-font.m_92852_((FormattedText)text2)) / 2.0f, 0.0f, color.asNum(), color.shadeWithBlueShift(0.4f, 0.2f).asNum(), matrix, (MultiBufferSource)bufferSource, 0xF000F0);
            } else {
                font.m_272077_((Component)text2, (float)(-font.m_92852_((FormattedText)text2)) / 2.0f, 0.0f, color.asNum(), false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
    }

    public void renderCounter(float pvX, float pvY, float pvZ, Camera pRenderInfo, Font font, Minecraft mc, float pPartialTicks) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate(pvX, pvY, pvZ);
        matrix.rotate((Quaternionfc)pRenderInfo.m_253121_());
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        float scale = DamagePopupParticle.easeOut((float)this.f_107224_ + pPartialTicks, 0.0f, 0.001f, this.f_107225_, (float)(this.shouldScale ? 250 : 200) * this.f_107663_ * (float)BSClientConfig.popupSizeMultiplier);
        matrix.scale(-scale, -scale, scale);
        matrix.translate(0.0f, 6.0f, -1.0f);
        DecimalFormat df = new DecimalFormat(BSClientConfig.damageDecimalFormat);
        MutableComponent text = Component.m_237113_((String)df.format(this.damage));
        if (BSClientConfig.showOutline) {
            font.m_168645_(text.m_7532_(), (float)(-font.m_92852_((FormattedText)text)) / 2.0f, 0.0f, this.uniqueColor.asNum(), this.uniqueColor.shadeWithBlueShift(0.4f, 0.2f).asNum(), matrix, (MultiBufferSource)bufferSource, 0xF000F0);
        } else {
            font.m_272077_((Component)text, (float)(-font.m_92852_((FormattedText)text)) / 2.0f, 0.0f, this.uniqueColor.asNum(), false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public static double[] calculateMidpoint(double x1, double y1, double z1, double x2, double y2, double z2) {
        double midX = (x1 + x2) / 2.0;
        double midY = (y1 + y2) / 2.0;
        double midZ = (z1 + z2) / 2.0;
        return new double[]{midX, midY, midZ};
    }

    public static double calculateDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    public static float easeOut(float timeElapsed, float startValue, float endValue, float maxTime, float overShoot) {
        timeElapsed = timeElapsed / maxTime - 1.0f;
        return endValue * (timeElapsed * timeElapsed * ((overShoot + 1.0f) * timeElapsed + overShoot) + 1.0f) + startValue;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class Provider
    implements ParticleProvider<DamagePopupParticleData> {
        public Provider(SpriteSet pSprites) {
        }

        public Particle createParticle(DamagePopupParticleData pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new DamagePopupParticle(pLevel, pX, pY, pZ, pType.damage(), pType.popupType());
        }
    }
}

