/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.mixin.offhandcombat;

import cinnamon.ofc.HandPlatform;
import cinnamon.ofc.Mod;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.aqutheseal.blessfulled.triggers.SpecialSoundsTriggers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HandPlatform.class})
public class HandPlatformMixin {
    @Inject(method={"resetAttackStrengthTickerOffHand"}, at={@At(value="HEAD")}, remap=false)
    private static void resetAttackStrengthTickerOffHand(Player player, CallbackInfo ci) {
        if (player instanceof LocalPlayer) {
            SpecialSoundsTriggers.playSwingSound(player, HandPlatformMixin.blessfulled$getAttackStrengthScale(player) > 0.2f);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lcinnamon/ofc/HandPlatform;canSwingHand(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Z", shift=At.Shift.AFTER)}, remap=false)
    private static void attack(Player player, Entity targetEntity, CallbackInfo ci) {
        if (player.m_9236_().f_46443_) {
            SpecialSoundsTriggers.playSwingSound(player, true);
        }
    }

    @Unique
    private static float blessfulled$getAttackStrengthScale(Player player) {
        ItemStack offhand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        HandPlatform.makeActive((Player)player, (ItemStack)offhand, (ItemStack)mainHand);
        Mod.Data data = Mod.get((Player)player);
        float f = Mth.m_14036_((float)((float)data.attackStrengthTicker / player.m_36333_()), (float)0.0f, (float)1.0f);
        HandPlatform.makeInactive((Player)player, (ItemStack)offhand, (ItemStack)mainHand);
        return f;
    }
}

