/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import org.aqutheseal.blessfulled.triggers.DamagePopupTriggers;
import org.aqutheseal.blessfulled.util.mixinhelper.CritTracker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements CritTracker {
    @Unique
    public boolean blessfulled$hasBeenCritted;

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatTracker;recordDamage(Lnet/minecraft/world/damagesource/DamageSource;F)V")})
    protected void actuallyHurt(DamageSource pDamageSource, float pDamageAmount, CallbackInfo ci) {
        DamagePopupTriggers.hurtTrigger((LivingEntity)this, pDamageSource, pDamageAmount);
    }

    @Inject(method={"heal"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getHealth()F")})
    public void heal(float pHealAmount, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_21223_() < entity.m_21233_()) {
            DamagePopupTriggers.healTrigger(entity, pHealAmount);
        }
    }

    @Override
    public boolean blessfulled$hasCritted() {
        return this.blessfulled$hasBeenCritted;
    }

    @Override
    public void blessfulled$disableHasCritted() {
        this.blessfulled$hasBeenCritted = false;
    }

    @Override
    public void blessfulled$enableHasCritted() {
        this.blessfulled$hasBeenCritted = true;
    }
}

