/*
 * Decompiled with CFR 0.152.
 */
package org.aqutheseal.blessfulled;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.aqutheseal.blessfulled.util.BSColor;
import org.aqutheseal.blessfulled.util.HurtTypes;

@Mod.EventBusSubscriber(modid="blessfulled", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BSClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static final ForgeConfigSpec.Builder POPUP_PUSH = BUILDER.push("Damage Popup Configuration");
    private static final ForgeConfigSpec.BooleanValue SHOULD_SHOW_EXPRESSION = BUILDER.comment("Should show onomatopoeia expressions in popup particle?").define("Show Expressions", true);
    private static final ForgeConfigSpec.BooleanValue SHOULD_OUTLINE = BUILDER.comment("Should text include outlines?").define("Show Text Outline", true);
    private static final ForgeConfigSpec.BooleanValue SHOULD_SHOW_COUNTER = BUILDER.comment("Should show damage counter in popup particle?").define("Show Damage Counter", true);
    private static final ForgeConfigSpec.DoubleValue POPUP_SIZE_MULTIPLIER = BUILDER.comment("Size multiplier for the hit particle popups.").defineInRange("Size Multiplier", 1.0, 0.0, Double.MAX_VALUE);
    private static final ForgeConfigSpec.ConfigValue<String> DAMAGE_POPUP_DECIMAL_FORMAT = BUILDER.comment("The decimal format for the popup damage text.").comment("e.g.: [0.000] will result in numbers like 7.325 while just [0] keeps it as whole numbers.").define("Damage Decimal Format", (Object)"0.00");
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> CRITICAL_COLOR = BUILDER.comment("RGB Color values for critical hit popups.").defineList("Critical Hit Popup Colors", List.of(Integer.valueOf(255), Integer.valueOf(196), Integer.valueOf(0)), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> HEAL_HIT_COLOR = BUILDER.comment("RGB Color values for heal popups.").defineList("Heal Popup Colors", List.of(Integer.valueOf(0), Integer.valueOf(255), Integer.valueOf(38)), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> MAGIC_HIT_COLOR = BUILDER.comment("RGB Color values for magic attack popups.").defineList("Melee Hit Popup Colors", List.of(Integer.valueOf(162), Integer.valueOf(0), Integer.valueOf(250)), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> GENERIC_HIT_COLOR = BUILDER.comment("RGB Color values for other damage type popups (becomes redder the higher the damage).").defineList("Generic Popup Colors", List.of(Integer.valueOf(255), Integer.valueOf(75), Integer.valueOf(75)), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MELEE_EXPRESSIONS_LIST = BUILDER.comment("A list of onomatopoeia expressions for melee hit popups.").defineList("Melee Expressions", List.of("CLANK!", "POW!", "BRUH!", "OUCH!", "WHAM!", "THWACK!", "BONK!", "SMACK!", "WHACK!", "BAM!"), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> CRIT_EXPRESSIONS_LIST = BUILDER.comment("A list of onomatopoeia expressions for critical melee hit popups.").defineList("Critical Melee Expressions", List.of("STRIKE!", "CRIT!", "CRUNCH!", "KABOOM!", "SMASH!", "OBLITERATE!", "DEVASTATE!", "ANNIHILATE!", "DECIMATE!", "SHATTER!"), s -> true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ARROW_CRIT_EXPRESSIONS_LIST = BUILDER.comment("A list of onomatopoeia expressions for critical arrow effect popups.").defineList("Critical Arrow Expressions", List.of("STRIKE!", "BULLSEYE!", "HEADSHOT?...!", "PIERCE!", "SNIPE!"), s -> true);
    static final ForgeConfigSpec.Builder POPUP_POP = BUILDER.pop();
    static final ForgeConfigSpec.Builder HURT_OVERLAY_PUSH = BUILDER.push("Hurt Overlay Configuration");
    private static final ForgeConfigSpec.EnumValue<HurtTypes> HURT_CONFIGURATION = BUILDER.comment("Configure the conditions to enable the entity white hurt overlay.").defineEnum("Hurt Overlay Condition", (Enum)HurtTypes.DEFAULT);
    static final ForgeConfigSpec.Builder HURT_OVERLAY_POP = BUILDER.pop();
    static final ForgeConfigSpec.Builder SOUNDS_PUSH = BUILDER.push("Special Sounds Configuration");
    private static final ForgeConfigSpec.BooleanValue SWING_SOUND = BUILDER.comment("Should play sounds on weapon swing?").define("Swinging Sounds", false);
    static final ForgeConfigSpec.Builder SOUNDS_POP = BUILDER.pop();
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean showExpression;
    public static boolean showOutline;
    public static boolean showDamage;
    public static double popupSizeMultiplier;
    public static String damageDecimalFormat;
    public static BSColor criticalColor;
    public static BSColor healColor;
    public static BSColor magicHitColor;
    public static BSColor genericColor;
    public static List<String> meleeExpressions;
    public static List<String> critMeleeExpressions;
    public static List<String> critArrowExpressions;
    public static HurtTypes hurtConfiguration;
    public static boolean swingSound;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        showExpression = (Boolean)SHOULD_SHOW_EXPRESSION.get();
        showOutline = (Boolean)SHOULD_OUTLINE.get();
        showDamage = (Boolean)SHOULD_SHOW_COUNTER.get();
        popupSizeMultiplier = (Double)POPUP_SIZE_MULTIPLIER.get();
        damageDecimalFormat = (String)DAMAGE_POPUP_DECIMAL_FORMAT.get();
        criticalColor = BSClientConfig.convertFromIntList((List)CRITICAL_COLOR.get());
        healColor = BSClientConfig.convertFromIntList((List)HEAL_HIT_COLOR.get());
        magicHitColor = BSClientConfig.convertFromIntList((List)MAGIC_HIT_COLOR.get());
        genericColor = BSClientConfig.convertFromIntList((List)GENERIC_HIT_COLOR.get());
        meleeExpressions = ((List)MELEE_EXPRESSIONS_LIST.get()).stream().map(String.class::cast).toList();
        critMeleeExpressions = ((List)CRIT_EXPRESSIONS_LIST.get()).stream().map(String.class::cast).toList();
        critArrowExpressions = ((List)ARROW_CRIT_EXPRESSIONS_LIST.get()).stream().map(String.class::cast).toList();
        hurtConfiguration = (HurtTypes)((Object)HURT_CONFIGURATION.get());
        swingSound = (Boolean)SWING_SOUND.get();
    }

    public static BSColor convertFromIntList(List<? extends Integer> intList) {
        if (intList.size() == 3) {
            return BSColor.fromIntList(intList.stream().map(Integer.class::cast).toList());
        }
        throw new IllegalStateException("Configuration Popup Damage Colors must have exactly 3 values.");
    }
}

