/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.mixin.AxeItemAccess;
import snownee.kiwi.mixin.FireBlockAccess;
import snownee.kiwi.mixin.HoeItemAccess;
import snownee.kiwi.mixin.ShovelItemAccess;
import snownee.kiwi.mixin.VillagerAccess;
import snownee.kiwi.mixin.WorkAtComposterAccess;

public final class VanillaActions {
    private VanillaActions() {
    }

    public static void setFireInfo(Block blockIn, int encouragement, int flammability) {
        ((FireBlockAccess)Blocks.f_50083_).callSetFlammable(blockIn, encouragement, flammability);
    }

    public static void registerHoeConversion(Block k, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> v) {
        HoeItemAccess.getTILLABLES().put(k, v);
    }

    public static void registerAxeConversion(Block k, Block v) {
        if (AxeItemAccess.getSTRIPPABLES() instanceof ImmutableMap) {
            AxeItemAccess.setSTRIPPABLES(Maps.newHashMap(AxeItemAccess.getSTRIPPABLES()));
        }
        AxeItemAccess.getSTRIPPABLES().put(k, v);
    }

    public static void registerShovelConversion(Block k, BlockState v) {
        if (ShovelItemAccess.getFLATTENABLES() instanceof ImmutableMap) {
            ShovelItemAccess.setFLATTENABLES(Maps.newHashMap(ShovelItemAccess.getFLATTENABLES()));
        }
        ShovelItemAccess.getFLATTENABLES().put(k, v);
    }

    public static void registerCompostable(float chance, ItemLike itemIn) {
        ComposterBlock.f_51914_.put((Object)itemIn.m_5456_(), chance);
    }

    public static void registerVillagerPickupable(ItemLike item) {
        if (VillagerAccess.getWANTED_ITEMS() instanceof ImmutableSet) {
            VillagerAccess.setWANTED_ITEMS(Sets.newHashSet(VillagerAccess.getWANTED_ITEMS()));
        }
        VillagerAccess.getWANTED_ITEMS().add(item.m_5456_());
    }

    public static void registerVillagerCompostable(ItemLike item) {
        if (WorkAtComposterAccess.getCOMPOSTABLE_ITEMS() instanceof ImmutableList) {
            WorkAtComposterAccess.setCOMPOSTABLE_ITEMS(Lists.newArrayList(WorkAtComposterAccess.getCOMPOSTABLE_ITEMS()));
        }
        WorkAtComposterAccess.getCOMPOSTABLE_ITEMS().add(item.m_5456_());
    }

    public static void registerVillagerFood(ItemLike item, int value) {
        if (VillagerAccess.getFOOD_POINTS() instanceof ImmutableMap) {
            VillagerAccess.setFOOD_POINTS(Maps.newHashMap(VillagerAccess.getFOOD_POINTS()));
        }
        VillagerAccess.getFOOD_POINTS().put(item.m_5456_(), value);
    }
}

