/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.scheduler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jrdemiurge.enigmaticdice.scheduler.SchedulerTask;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enigmaticdice")
public class Scheduler {
    private static final List<SchedulerTask> tasks = new ArrayList<SchedulerTask>();
    private static final List<SchedulerTask> newTasks = new ArrayList<SchedulerTask>();

    public static void schedule(Runnable task, int delay) {
        Scheduler.schedule(task, delay, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Runnable task, int delay, int period, int repeatCount) {
        List<SchedulerTask> list = tasks;
        synchronized (list) {
            newTasks.add(new SchedulerTask(task, delay, period, repeatCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            List<SchedulerTask> list = newTasks;
            synchronized (list) {
                if (!newTasks.isEmpty()) {
                    tasks.addAll(newTasks);
                    newTasks.clear();
                }
            }
            list = tasks;
            synchronized (list) {
                Iterator<SchedulerTask> iterator = tasks.iterator();
                while (iterator.hasNext()) {
                    SchedulerTask st = iterator.next();
                    int newTicks = st.getTicksRemaining() - 1;
                    st.setTicksRemaining(newTicks);
                    if (newTicks > 0) continue;
                    st.getTask().run();
                    if (st.isRepeating()) {
                        st.decrementRepeatCount();
                        if (st.getRepeatCount() < 1) {
                            iterator.remove();
                            continue;
                        }
                        st.setTicksRemaining(st.getPeriod());
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }
}

