/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.enigmaticdice.network;

import java.util.function.Supplier;
import net.jrdemiurge.enigmaticdice.event.ClientTimeHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TimeAccelStartPacket {
    private final int multiplier;
    private final int durationTicks;

    public TimeAccelStartPacket(int multiplier, int durationTicks) {
        this.multiplier = multiplier;
        this.durationTicks = durationTicks;
    }

    public static void encode(TimeAccelStartPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.multiplier);
        buf.m_130130_(msg.durationTicks);
    }

    public static TimeAccelStartPacket decode(FriendlyByteBuf buf) {
        int mul = buf.m_130242_();
        int dur = buf.m_130242_();
        return new TimeAccelStartPacket(mul, dur);
    }

    public static void handle(TimeAccelStartPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientTimeHandler.start(msg.multiplier, msg.durationTicks));
        ctx.get().setPacketHandled(true);
    }
}

